<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStatus StructType
 * @subpackage Structs
 */
class TStatus extends AbstractStructBase
{
    /**
     * The StatusId
     * @var int
     */
    public $StatusId;
    /**
     * The Statusname
     * @var string
     */
    public $Statusname;
    /**
     * The StatusType
     * @var string
     */
    public $StatusType;
    /**
     * Constructor method for TStatus
     * @uses TStatus::setStatusId()
     * @uses TStatus::setStatusname()
     * @uses TStatus::setStatusType()
     * @param int $statusId
     * @param string $statusname
     * @param string $statusType
     */
    public function __construct($statusId = null, $statusname = null, $statusType = null)
    {
        $this
            ->setStatusId($statusId)
            ->setStatusname($statusname)
            ->setStatusType($statusType);
    }
    /**
     * Get StatusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param int $statusId
     * @return \StructType\TStatus
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !is_numeric($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusId)), __LINE__);
        }
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Get Statusname value
     * @return string|null
     */
    public function getStatusname()
    {
        return $this->Statusname;
    }
    /**
     * Set Statusname value
     * @param string $statusname
     * @return \StructType\TStatus
     */
    public function setStatusname($statusname = null)
    {
        // validation for constraint: string
        if (!is_null($statusname) && !is_string($statusname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusname)), __LINE__);
        }
        $this->Statusname = $statusname;
        return $this;
    }
    /**
     * Get StatusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @param string $statusType
     * @return \StructType\TStatus
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusType)), __LINE__);
        }
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
