<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TSite StructType
 * @subpackage Structs
 */
class TSite extends AbstractStructBase
{
    /**
     * The SiteId
     * @var int
     */
    public $SiteId;
    /**
     * The SiteName
     * @var string
     */
    public $SiteName;
    /**
     * The SiteAddress1
     * @var string
     */
    public $SiteAddress1;
    /**
     * The SiteAddress2
     * @var string
     */
    public $SiteAddress2;
    /**
     * The SiteZipCode
     * @var string
     */
    public $SiteZipCode;
    /**
     * The SiteCity
     * @var string
     */
    public $SiteCity;
    /**
     * The SitePhone
     * @var string
     */
    public $SitePhone;
    /**
     * The SiteCode
     * @var string
     */
    public $SiteCode;
    /**
     * The SiteEmail
     * @var string
     */
    public $SiteEmail;
    /**
     * Constructor method for TSite
     * @uses TSite::setSiteId()
     * @uses TSite::setSiteName()
     * @uses TSite::setSiteAddress1()
     * @uses TSite::setSiteAddress2()
     * @uses TSite::setSiteZipCode()
     * @uses TSite::setSiteCity()
     * @uses TSite::setSitePhone()
     * @uses TSite::setSiteCode()
     * @uses TSite::setSiteEmail()
     * @param int $siteId
     * @param string $siteName
     * @param string $siteAddress1
     * @param string $siteAddress2
     * @param string $siteZipCode
     * @param string $siteCity
     * @param string $sitePhone
     * @param string $siteCode
     * @param string $siteEmail
     */
    public function __construct($siteId = null, $siteName = null, $siteAddress1 = null, $siteAddress2 = null, $siteZipCode = null, $siteCity = null, $sitePhone = null, $siteCode = null, $siteEmail = null)
    {
        $this
            ->setSiteId($siteId)
            ->setSiteName($siteName)
            ->setSiteAddress1($siteAddress1)
            ->setSiteAddress2($siteAddress2)
            ->setSiteZipCode($siteZipCode)
            ->setSiteCity($siteCity)
            ->setSitePhone($sitePhone)
            ->setSiteCode($siteCode)
            ->setSiteEmail($siteEmail);
    }
    /**
     * Get SiteId value
     * @return int|null
     */
    public function getSiteId()
    {
        return $this->SiteId;
    }
    /**
     * Set SiteId value
     * @param int $siteId
     * @return \StructType\TSite
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: int
        if (!is_null($siteId) && !is_numeric($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteId)), __LINE__);
        }
        $this->SiteId = $siteId;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \StructType\TSite
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteName)), __LINE__);
        }
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Get SiteAddress1 value
     * @return string|null
     */
    public function getSiteAddress1()
    {
        return $this->SiteAddress1;
    }
    /**
     * Set SiteAddress1 value
     * @param string $siteAddress1
     * @return \StructType\TSite
     */
    public function setSiteAddress1($siteAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress1) && !is_string($siteAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteAddress1)), __LINE__);
        }
        $this->SiteAddress1 = $siteAddress1;
        return $this;
    }
    /**
     * Get SiteAddress2 value
     * @return string|null
     */
    public function getSiteAddress2()
    {
        return $this->SiteAddress2;
    }
    /**
     * Set SiteAddress2 value
     * @param string $siteAddress2
     * @return \StructType\TSite
     */
    public function setSiteAddress2($siteAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress2) && !is_string($siteAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteAddress2)), __LINE__);
        }
        $this->SiteAddress2 = $siteAddress2;
        return $this;
    }
    /**
     * Get SiteZipCode value
     * @return string|null
     */
    public function getSiteZipCode()
    {
        return $this->SiteZipCode;
    }
    /**
     * Set SiteZipCode value
     * @param string $siteZipCode
     * @return \StructType\TSite
     */
    public function setSiteZipCode($siteZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteZipCode) && !is_string($siteZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteZipCode)), __LINE__);
        }
        $this->SiteZipCode = $siteZipCode;
        return $this;
    }
    /**
     * Get SiteCity value
     * @return string|null
     */
    public function getSiteCity()
    {
        return $this->SiteCity;
    }
    /**
     * Set SiteCity value
     * @param string $siteCity
     * @return \StructType\TSite
     */
    public function setSiteCity($siteCity = null)
    {
        // validation for constraint: string
        if (!is_null($siteCity) && !is_string($siteCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteCity)), __LINE__);
        }
        $this->SiteCity = $siteCity;
        return $this;
    }
    /**
     * Get SitePhone value
     * @return string|null
     */
    public function getSitePhone()
    {
        return $this->SitePhone;
    }
    /**
     * Set SitePhone value
     * @param string $sitePhone
     * @return \StructType\TSite
     */
    public function setSitePhone($sitePhone = null)
    {
        // validation for constraint: string
        if (!is_null($sitePhone) && !is_string($sitePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sitePhone)), __LINE__);
        }
        $this->SitePhone = $sitePhone;
        return $this;
    }
    /**
     * Get SiteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->SiteCode;
    }
    /**
     * Set SiteCode value
     * @param string $siteCode
     * @return \StructType\TSite
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteCode)), __LINE__);
        }
        $this->SiteCode = $siteCode;
        return $this;
    }
    /**
     * Get SiteEmail value
     * @return string|null
     */
    public function getSiteEmail()
    {
        return $this->SiteEmail;
    }
    /**
     * Set SiteEmail value
     * @param string $siteEmail
     * @return \StructType\TSite
     */
    public function setSiteEmail($siteEmail = null)
    {
        // validation for constraint: string
        if (!is_null($siteEmail) && !is_string($siteEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteEmail)), __LINE__);
        }
        $this->SiteEmail = $siteEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TSite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
