<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TRendezVous StructType
 * @subpackage Structs
 */
class TRendezVous extends AbstractStructBase
{
    /**
     * The RdvId
     * @var int
     */
    public $RdvId;
    /**
     * The RdvType
     * @var int
     */
    public $RdvType;
    /**
     * The SiteCode
     * @var string
     */
    public $SiteCode;
    /**
     * The WorkshopCode
     * @var string
     */
    public $WorkshopCode;
    /**
     * The ReceivingCode
     * @var string
     */
    public $ReceivingCode;
    /**
     * The CliDMSId
     * @var string
     */
    public $CliDMSId;
    /**
     * The VehVIN
     * @var string
     */
    public $VehVIN;
    /**
     * The VehRegNum
     * @var string
     */
    public $VehRegNum;
    /**
     * The RdvRONum
     * @var string
     */
    public $RdvRONum;
    /**
     * The RdvStart
     * @var string
     */
    public $RdvStart;
    /**
     * The RdvFinish
     * @var string
     */
    public $RdvFinish;
    /**
     * The RdvPartsState
     * @var int
     */
    public $RdvPartsState;
    /**
     * The RdvState
     * @var int
     */
    public $RdvState;
    /**
     * The RdvReceivingComment
     * @var string
     */
    public $RdvReceivingComment;
    /**
     * The RdvWorkshopComment
     * @var string
     */
    public $RdvWorkshopComment;
    /**
     * The RdvPartsComment
     * @var string
     */
    public $RdvPartsComment;
    /**
     * The RdvLoaner
     * @var int
     */
    public $RdvLoaner;
    /**
     * The RdvDuration
     * @var int
     */
    public $RdvDuration;
    /**
     * The RdvSoldHours
     * @var int
     */
    public $RdvSoldHours;
    /**
     * The RdvWorkHours
     * @var int
     */
    public $RdvWorkHours;
    /**
     * The RdvSaleTotal
     * @var float
     */
    public $RdvSaleTotal;
    /**
     * The RdvTicketNum
     * @var string
     */
    public $RdvTicketNum;
    /**
     * The RdvBookedOnline
     * @var int
     */
    public $RdvBookedOnline;
    /**
     * The RdvActive
     * @var int
     */
    public $RdvActive;
    /**
     * The WorkLineList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkLine[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkLine[]
     */
    public $WorkLineList;
    /**
     * The VehKm
     * @var string
     */
    public $VehKm;
    /**
     * The ProviderCliId
     * @var string
     */
    public $ProviderCliId;
    /**
     * The ProviderVehId
     * @var string
     */
    public $ProviderVehId;
    /**
     * The ProviderRdvId
     * @var string
     */
    public $ProviderRdvId;
    /**
     * The RdvClientWait
     * @var int
     */
    public $RdvClientWait;
    /**
     * Constructor method for TRendezVous
     * @uses TRendezVous::setRdvId()
     * @uses TRendezVous::setRdvType()
     * @uses TRendezVous::setSiteCode()
     * @uses TRendezVous::setWorkshopCode()
     * @uses TRendezVous::setReceivingCode()
     * @uses TRendezVous::setCliDMSId()
     * @uses TRendezVous::setVehVIN()
     * @uses TRendezVous::setVehRegNum()
     * @uses TRendezVous::setRdvRONum()
     * @uses TRendezVous::setRdvStart()
     * @uses TRendezVous::setRdvFinish()
     * @uses TRendezVous::setRdvPartsState()
     * @uses TRendezVous::setRdvState()
     * @uses TRendezVous::setRdvReceivingComment()
     * @uses TRendezVous::setRdvWorkshopComment()
     * @uses TRendezVous::setRdvPartsComment()
     * @uses TRendezVous::setRdvLoaner()
     * @uses TRendezVous::setRdvDuration()
     * @uses TRendezVous::setRdvSoldHours()
     * @uses TRendezVous::setRdvWorkHours()
     * @uses TRendezVous::setRdvSaleTotal()
     * @uses TRendezVous::setRdvTicketNum()
     * @uses TRendezVous::setRdvBookedOnline()
     * @uses TRendezVous::setRdvActive()
     * @uses TRendezVous::setWorkLineList()
     * @uses TRendezVous::setVehKm()
     * @uses TRendezVous::setProviderCliId()
     * @uses TRendezVous::setProviderVehId()
     * @uses TRendezVous::setProviderRdvId()
     * @uses TRendezVous::setRdvClientWait()
     * @param int $rdvId
     * @param int $rdvType
     * @param string $siteCode
     * @param string $workshopCode
     * @param string $receivingCode
     * @param string $cliDMSId
     * @param string $vehVIN
     * @param string $vehRegNum
     * @param string $rdvRONum
     * @param string $rdvStart
     * @param string $rdvFinish
     * @param int $rdvPartsState
     * @param int $rdvState
     * @param string $rdvReceivingComment
     * @param string $rdvWorkshopComment
     * @param string $rdvPartsComment
     * @param int $rdvLoaner
     * @param int $rdvDuration
     * @param int $rdvSoldHours
     * @param int $rdvWorkHours
     * @param float $rdvSaleTotal
     * @param string $rdvTicketNum
     * @param int $rdvBookedOnline
     * @param int $rdvActive
     * @param \StructType\TWorkLine[] $workLineList
     * @param string $vehKm
     * @param string $providerCliId
     * @param string $providerVehId
     * @param string $providerRdvId
     * @param int $rdvClientWait
     */
    public function __construct($rdvId = null, $rdvType = null, $siteCode = null, $workshopCode = null, $receivingCode = null, $cliDMSId = null, $vehVIN = null, $vehRegNum = null, $rdvRONum = null, $rdvStart = null, $rdvFinish = null, $rdvPartsState = null, $rdvState = null, $rdvReceivingComment = null, $rdvWorkshopComment = null, $rdvPartsComment = null, $rdvLoaner = null, $rdvDuration = null, $rdvSoldHours = null, $rdvWorkHours = null, $rdvSaleTotal = null, $rdvTicketNum = null, $rdvBookedOnline = null, $rdvActive = null, array $workLineList = array(), $vehKm = null, $providerCliId = null, $providerVehId = null, $providerRdvId = null, $rdvClientWait = null)
    {
        $this
            ->setRdvId($rdvId)
            ->setRdvType($rdvType)
            ->setSiteCode($siteCode)
            ->setWorkshopCode($workshopCode)
            ->setReceivingCode($receivingCode)
            ->setCliDMSId($cliDMSId)
            ->setVehVIN($vehVIN)
            ->setVehRegNum($vehRegNum)
            ->setRdvRONum($rdvRONum)
            ->setRdvStart($rdvStart)
            ->setRdvFinish($rdvFinish)
            ->setRdvPartsState($rdvPartsState)
            ->setRdvState($rdvState)
            ->setRdvReceivingComment($rdvReceivingComment)
            ->setRdvWorkshopComment($rdvWorkshopComment)
            ->setRdvPartsComment($rdvPartsComment)
            ->setRdvLoaner($rdvLoaner)
            ->setRdvDuration($rdvDuration)
            ->setRdvSoldHours($rdvSoldHours)
            ->setRdvWorkHours($rdvWorkHours)
            ->setRdvSaleTotal($rdvSaleTotal)
            ->setRdvTicketNum($rdvTicketNum)
            ->setRdvBookedOnline($rdvBookedOnline)
            ->setRdvActive($rdvActive)
            ->setWorkLineList($workLineList)
            ->setVehKm($vehKm)
            ->setProviderCliId($providerCliId)
            ->setProviderVehId($providerVehId)
            ->setProviderRdvId($providerRdvId)
            ->setRdvClientWait($rdvClientWait);
    }
    /**
     * Get RdvId value
     * @return int|null
     */
    public function getRdvId()
    {
        return $this->RdvId;
    }
    /**
     * Set RdvId value
     * @param int $rdvId
     * @return \StructType\TRendezVous
     */
    public function setRdvId($rdvId = null)
    {
        // validation for constraint: int
        if (!is_null($rdvId) && !is_numeric($rdvId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvId)), __LINE__);
        }
        $this->RdvId = $rdvId;
        return $this;
    }
    /**
     * Get RdvType value
     * @return int|null
     */
    public function getRdvType()
    {
        return $this->RdvType;
    }
    /**
     * Set RdvType value
     * @param int $rdvType
     * @return \StructType\TRendezVous
     */
    public function setRdvType($rdvType = null)
    {
        // validation for constraint: int
        if (!is_null($rdvType) && !is_numeric($rdvType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvType)), __LINE__);
        }
        $this->RdvType = $rdvType;
        return $this;
    }
    /**
     * Get SiteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->SiteCode;
    }
    /**
     * Set SiteCode value
     * @param string $siteCode
     * @return \StructType\TRendezVous
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteCode)), __LINE__);
        }
        $this->SiteCode = $siteCode;
        return $this;
    }
    /**
     * Get WorkshopCode value
     * @return string|null
     */
    public function getWorkshopCode()
    {
        return $this->WorkshopCode;
    }
    /**
     * Set WorkshopCode value
     * @param string $workshopCode
     * @return \StructType\TRendezVous
     */
    public function setWorkshopCode($workshopCode = null)
    {
        // validation for constraint: string
        if (!is_null($workshopCode) && !is_string($workshopCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workshopCode)), __LINE__);
        }
        $this->WorkshopCode = $workshopCode;
        return $this;
    }
    /**
     * Get ReceivingCode value
     * @return string|null
     */
    public function getReceivingCode()
    {
        return $this->ReceivingCode;
    }
    /**
     * Set ReceivingCode value
     * @param string $receivingCode
     * @return \StructType\TRendezVous
     */
    public function setReceivingCode($receivingCode = null)
    {
        // validation for constraint: string
        if (!is_null($receivingCode) && !is_string($receivingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivingCode)), __LINE__);
        }
        $this->ReceivingCode = $receivingCode;
        return $this;
    }
    /**
     * Get CliDMSId value
     * @return string|null
     */
    public function getCliDMSId()
    {
        return $this->CliDMSId;
    }
    /**
     * Set CliDMSId value
     * @param string $cliDMSId
     * @return \StructType\TRendezVous
     */
    public function setCliDMSId($cliDMSId = null)
    {
        // validation for constraint: string
        if (!is_null($cliDMSId) && !is_string($cliDMSId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliDMSId)), __LINE__);
        }
        $this->CliDMSId = $cliDMSId;
        return $this;
    }
    /**
     * Get VehVIN value
     * @return string|null
     */
    public function getVehVIN()
    {
        return $this->VehVIN;
    }
    /**
     * Set VehVIN value
     * @param string $vehVIN
     * @return \StructType\TRendezVous
     */
    public function setVehVIN($vehVIN = null)
    {
        // validation for constraint: string
        if (!is_null($vehVIN) && !is_string($vehVIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehVIN)), __LINE__);
        }
        $this->VehVIN = $vehVIN;
        return $this;
    }
    /**
     * Get VehRegNum value
     * @return string|null
     */
    public function getVehRegNum()
    {
        return $this->VehRegNum;
    }
    /**
     * Set VehRegNum value
     * @param string $vehRegNum
     * @return \StructType\TRendezVous
     */
    public function setVehRegNum($vehRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vehRegNum) && !is_string($vehRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehRegNum)), __LINE__);
        }
        $this->VehRegNum = $vehRegNum;
        return $this;
    }
    /**
     * Get RdvRONum value
     * @return string|null
     */
    public function getRdvRONum()
    {
        return $this->RdvRONum;
    }
    /**
     * Set RdvRONum value
     * @param string $rdvRONum
     * @return \StructType\TRendezVous
     */
    public function setRdvRONum($rdvRONum = null)
    {
        // validation for constraint: string
        if (!is_null($rdvRONum) && !is_string($rdvRONum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvRONum)), __LINE__);
        }
        $this->RdvRONum = $rdvRONum;
        return $this;
    }
    /**
     * Get RdvStart value
     * @return string|null
     */
    public function getRdvStart()
    {
        return $this->RdvStart;
    }
    /**
     * Set RdvStart value
     * @param string $rdvStart
     * @return \StructType\TRendezVous
     */
    public function setRdvStart($rdvStart = null)
    {
        // validation for constraint: string
        if (!is_null($rdvStart) && !is_string($rdvStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvStart)), __LINE__);
        }
        $this->RdvStart = $rdvStart;
        return $this;
    }
    /**
     * Get RdvFinish value
     * @return string|null
     */
    public function getRdvFinish()
    {
        return $this->RdvFinish;
    }
    /**
     * Set RdvFinish value
     * @param string $rdvFinish
     * @return \StructType\TRendezVous
     */
    public function setRdvFinish($rdvFinish = null)
    {
        // validation for constraint: string
        if (!is_null($rdvFinish) && !is_string($rdvFinish)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvFinish)), __LINE__);
        }
        $this->RdvFinish = $rdvFinish;
        return $this;
    }
    /**
     * Get RdvPartsState value
     * @return int|null
     */
    public function getRdvPartsState()
    {
        return $this->RdvPartsState;
    }
    /**
     * Set RdvPartsState value
     * @param int $rdvPartsState
     * @return \StructType\TRendezVous
     */
    public function setRdvPartsState($rdvPartsState = null)
    {
        // validation for constraint: int
        if (!is_null($rdvPartsState) && !is_numeric($rdvPartsState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvPartsState)), __LINE__);
        }
        $this->RdvPartsState = $rdvPartsState;
        return $this;
    }
    /**
     * Get RdvState value
     * @return int|null
     */
    public function getRdvState()
    {
        return $this->RdvState;
    }
    /**
     * Set RdvState value
     * @param int $rdvState
     * @return \StructType\TRendezVous
     */
    public function setRdvState($rdvState = null)
    {
        // validation for constraint: int
        if (!is_null($rdvState) && !is_numeric($rdvState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvState)), __LINE__);
        }
        $this->RdvState = $rdvState;
        return $this;
    }
    /**
     * Get RdvReceivingComment value
     * @return string|null
     */
    public function getRdvReceivingComment()
    {
        return $this->RdvReceivingComment;
    }
    /**
     * Set RdvReceivingComment value
     * @param string $rdvReceivingComment
     * @return \StructType\TRendezVous
     */
    public function setRdvReceivingComment($rdvReceivingComment = null)
    {
        // validation for constraint: string
        if (!is_null($rdvReceivingComment) && !is_string($rdvReceivingComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvReceivingComment)), __LINE__);
        }
        $this->RdvReceivingComment = $rdvReceivingComment;
        return $this;
    }
    /**
     * Get RdvWorkshopComment value
     * @return string|null
     */
    public function getRdvWorkshopComment()
    {
        return $this->RdvWorkshopComment;
    }
    /**
     * Set RdvWorkshopComment value
     * @param string $rdvWorkshopComment
     * @return \StructType\TRendezVous
     */
    public function setRdvWorkshopComment($rdvWorkshopComment = null)
    {
        // validation for constraint: string
        if (!is_null($rdvWorkshopComment) && !is_string($rdvWorkshopComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvWorkshopComment)), __LINE__);
        }
        $this->RdvWorkshopComment = $rdvWorkshopComment;
        return $this;
    }
    /**
     * Get RdvPartsComment value
     * @return string|null
     */
    public function getRdvPartsComment()
    {
        return $this->RdvPartsComment;
    }
    /**
     * Set RdvPartsComment value
     * @param string $rdvPartsComment
     * @return \StructType\TRendezVous
     */
    public function setRdvPartsComment($rdvPartsComment = null)
    {
        // validation for constraint: string
        if (!is_null($rdvPartsComment) && !is_string($rdvPartsComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvPartsComment)), __LINE__);
        }
        $this->RdvPartsComment = $rdvPartsComment;
        return $this;
    }
    /**
     * Get RdvLoaner value
     * @return int|null
     */
    public function getRdvLoaner()
    {
        return $this->RdvLoaner;
    }
    /**
     * Set RdvLoaner value
     * @param int $rdvLoaner
     * @return \StructType\TRendezVous
     */
    public function setRdvLoaner($rdvLoaner = null)
    {
        // validation for constraint: int
        if (!is_null($rdvLoaner) && !is_numeric($rdvLoaner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvLoaner)), __LINE__);
        }
        $this->RdvLoaner = $rdvLoaner;
        return $this;
    }
    /**
     * Get RdvDuration value
     * @return int|null
     */
    public function getRdvDuration()
    {
        return $this->RdvDuration;
    }
    /**
     * Set RdvDuration value
     * @param int $rdvDuration
     * @return \StructType\TRendezVous
     */
    public function setRdvDuration($rdvDuration = null)
    {
        // validation for constraint: int
        if (!is_null($rdvDuration) && !is_numeric($rdvDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvDuration)), __LINE__);
        }
        $this->RdvDuration = $rdvDuration;
        return $this;
    }
    /**
     * Get RdvSoldHours value
     * @return int|null
     */
    public function getRdvSoldHours()
    {
        return $this->RdvSoldHours;
    }
    /**
     * Set RdvSoldHours value
     * @param int $rdvSoldHours
     * @return \StructType\TRendezVous
     */
    public function setRdvSoldHours($rdvSoldHours = null)
    {
        // validation for constraint: int
        if (!is_null($rdvSoldHours) && !is_numeric($rdvSoldHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvSoldHours)), __LINE__);
        }
        $this->RdvSoldHours = $rdvSoldHours;
        return $this;
    }
    /**
     * Get RdvWorkHours value
     * @return int|null
     */
    public function getRdvWorkHours()
    {
        return $this->RdvWorkHours;
    }
    /**
     * Set RdvWorkHours value
     * @param int $rdvWorkHours
     * @return \StructType\TRendezVous
     */
    public function setRdvWorkHours($rdvWorkHours = null)
    {
        // validation for constraint: int
        if (!is_null($rdvWorkHours) && !is_numeric($rdvWorkHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvWorkHours)), __LINE__);
        }
        $this->RdvWorkHours = $rdvWorkHours;
        return $this;
    }
    /**
     * Get RdvSaleTotal value
     * @return float|null
     */
    public function getRdvSaleTotal()
    {
        return $this->RdvSaleTotal;
    }
    /**
     * Set RdvSaleTotal value
     * @param float $rdvSaleTotal
     * @return \StructType\TRendezVous
     */
    public function setRdvSaleTotal($rdvSaleTotal = null)
    {
        $this->RdvSaleTotal = $rdvSaleTotal;
        return $this;
    }
    /**
     * Get RdvTicketNum value
     * @return string|null
     */
    public function getRdvTicketNum()
    {
        return $this->RdvTicketNum;
    }
    /**
     * Set RdvTicketNum value
     * @param string $rdvTicketNum
     * @return \StructType\TRendezVous
     */
    public function setRdvTicketNum($rdvTicketNum = null)
    {
        // validation for constraint: string
        if (!is_null($rdvTicketNum) && !is_string($rdvTicketNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rdvTicketNum)), __LINE__);
        }
        $this->RdvTicketNum = $rdvTicketNum;
        return $this;
    }
    /**
     * Get RdvBookedOnline value
     * @return int|null
     */
    public function getRdvBookedOnline()
    {
        return $this->RdvBookedOnline;
    }
    /**
     * Set RdvBookedOnline value
     * @param int $rdvBookedOnline
     * @return \StructType\TRendezVous
     */
    public function setRdvBookedOnline($rdvBookedOnline = null)
    {
        // validation for constraint: int
        if (!is_null($rdvBookedOnline) && !is_numeric($rdvBookedOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvBookedOnline)), __LINE__);
        }
        $this->RdvBookedOnline = $rdvBookedOnline;
        return $this;
    }
    /**
     * Get RdvActive value
     * @return int|null
     */
    public function getRdvActive()
    {
        return $this->RdvActive;
    }
    /**
     * Set RdvActive value
     * @param int $rdvActive
     * @return \StructType\TRendezVous
     */
    public function setRdvActive($rdvActive = null)
    {
        // validation for constraint: int
        if (!is_null($rdvActive) && !is_numeric($rdvActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvActive)), __LINE__);
        }
        $this->RdvActive = $rdvActive;
        return $this;
    }
    /**
     * Get WorkLineList value
     * @return \StructType\TWorkLine[]|null
     */
    public function getWorkLineList()
    {
        return $this->WorkLineList;
    }
    /**
     * Set WorkLineList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkLine[] $workLineList
     * @return \StructType\TRendezVous
     */
    public function setWorkLineList(array $workLineList = array())
    {
        foreach ($workLineList as $tRendezVousWorkLineListItem) {
            // validation for constraint: itemType
            if (!$tRendezVousWorkLineListItem instanceof \StructType\TWorkLine) {
                throw new \InvalidArgumentException(sprintf('The WorkLineList property can only contain items of \StructType\TWorkLine, "%s" given', is_object($tRendezVousWorkLineListItem) ? get_class($tRendezVousWorkLineListItem) : gettype($tRendezVousWorkLineListItem)), __LINE__);
            }
        }
        $this->WorkLineList = $workLineList;
        return $this;
    }
    /**
     * Add item to WorkLineList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkLine $item
     * @return \StructType\TRendezVous
     */
    public function addToWorkLineList(\StructType\TWorkLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkLine) {
            throw new \InvalidArgumentException(sprintf('The WorkLineList property can only contain items of \StructType\TWorkLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WorkLineList[] = $item;
        return $this;
    }
    /**
     * Get VehKm value
     * @return string|null
     */
    public function getVehKm()
    {
        return $this->VehKm;
    }
    /**
     * Set VehKm value
     * @param string $vehKm
     * @return \StructType\TRendezVous
     */
    public function setVehKm($vehKm = null)
    {
        // validation for constraint: string
        if (!is_null($vehKm) && !is_string($vehKm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehKm)), __LINE__);
        }
        $this->VehKm = $vehKm;
        return $this;
    }
    /**
     * Get ProviderCliId value
     * @return string|null
     */
    public function getProviderCliId()
    {
        return $this->ProviderCliId;
    }
    /**
     * Set ProviderCliId value
     * @param string $providerCliId
     * @return \StructType\TRendezVous
     */
    public function setProviderCliId($providerCliId = null)
    {
        // validation for constraint: string
        if (!is_null($providerCliId) && !is_string($providerCliId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerCliId)), __LINE__);
        }
        $this->ProviderCliId = $providerCliId;
        return $this;
    }
    /**
     * Get ProviderVehId value
     * @return string|null
     */
    public function getProviderVehId()
    {
        return $this->ProviderVehId;
    }
    /**
     * Set ProviderVehId value
     * @param string $providerVehId
     * @return \StructType\TRendezVous
     */
    public function setProviderVehId($providerVehId = null)
    {
        // validation for constraint: string
        if (!is_null($providerVehId) && !is_string($providerVehId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerVehId)), __LINE__);
        }
        $this->ProviderVehId = $providerVehId;
        return $this;
    }
    /**
     * Get ProviderRdvId value
     * @return string|null
     */
    public function getProviderRdvId()
    {
        return $this->ProviderRdvId;
    }
    /**
     * Set ProviderRdvId value
     * @param string $providerRdvId
     * @return \StructType\TRendezVous
     */
    public function setProviderRdvId($providerRdvId = null)
    {
        // validation for constraint: string
        if (!is_null($providerRdvId) && !is_string($providerRdvId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerRdvId)), __LINE__);
        }
        $this->ProviderRdvId = $providerRdvId;
        return $this;
    }
    /**
     * Get RdvClientWait value
     * @return int|null
     */
    public function getRdvClientWait()
    {
        return $this->RdvClientWait;
    }
    /**
     * Set RdvClientWait value
     * @param int $rdvClientWait
     * @return \StructType\TRendezVous
     */
    public function setRdvClientWait($rdvClientWait = null)
    {
        // validation for constraint: int
        if (!is_null($rdvClientWait) && !is_numeric($rdvClientWait)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rdvClientWait)), __LINE__);
        }
        $this->RdvClientWait = $rdvClientWait;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TRendezVous
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
