<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TClient StructType
 * @subpackage Structs
 */
class TClient extends AbstractStructBase
{
    /**
     * The CliId
     * @var int
     */
    public $CliId;
    /**
     * The CliDMSId
     * @var string
     */
    public $CliDMSId;
    /**
     * The CliTitle
     * @var string
     */
    public $CliTitle;
    /**
     * The CliFamName
     * @var string
     */
    public $CliFamName;
    /**
     * The CliFirName
     * @var string
     */
    public $CliFirName;
    /**
     * The CliAddr1
     * @var string
     */
    public $CliAddr1;
    /**
     * The CliAddr2
     * @var string
     */
    public $CliAddr2;
    /**
     * The CliPC
     * @var string
     */
    public $CliPC;
    /**
     * The CliCity
     * @var string
     */
    public $CliCity;
    /**
     * The CliHomePhone
     * @var string
     */
    public $CliHomePhone;
    /**
     * The CliCellPhone
     * @var string
     */
    public $CliCellPhone;
    /**
     * The CliWorkPhone
     * @var string
     */
    public $CliWorkPhone;
    /**
     * The CliFax
     * @var string
     */
    public $CliFax;
    /**
     * The CliEmail
     * @var string
     */
    public $CliEmail;
    /**
     * The CliAccountType
     * @var string
     */
    public $CliAccountType;
    /**
     * The CliState
     * @var string
     */
    public $CliState;
    /**
     * The CliCountry
     * @var string
     */
    public $CliCountry;
    /**
     * The CliTags
     * @var string
     */
    public $CliTags;
    /**
     * The CliDoNotText
     * @var int
     */
    public $CliDoNotText;
    /**
     * The CliDoNotEmail
     * @var int
     */
    public $CliDoNotEmail;
    /**
     * The CliDoNotPhone
     * @var int
     */
    public $CliDoNotPhone;
    /**
     * The CliCashPayment
     * @var int
     */
    public $CliCashPayment;
    /**
     * The CliLocked
     * @var int
     */
    public $CliLocked;
    /**
     * The CliLanguage
     * @var string
     */
    public $CliLanguage;
    /**
     * The ProviderCliId
     * @var string
     */
    public $ProviderCliId;
    /**
     * The CliActive
     * @var int
     */
    public $CliActive;
    /**
     * The CliVehicleList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TVehicle[]
     * - ref: soapenc:arrayType
     * @var \StructType\TVehicle[]
     */
    public $CliVehicleList;
    /**
     * The ContactList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TContact[]
     * - ref: soapenc:arrayType
     * @var \StructType\TContact[]
     */
    public $ContactList;
    /**
     * Constructor method for TClient
     * @uses TClient::setCliId()
     * @uses TClient::setCliDMSId()
     * @uses TClient::setCliTitle()
     * @uses TClient::setCliFamName()
     * @uses TClient::setCliFirName()
     * @uses TClient::setCliAddr1()
     * @uses TClient::setCliAddr2()
     * @uses TClient::setCliPC()
     * @uses TClient::setCliCity()
     * @uses TClient::setCliHomePhone()
     * @uses TClient::setCliCellPhone()
     * @uses TClient::setCliWorkPhone()
     * @uses TClient::setCliFax()
     * @uses TClient::setCliEmail()
     * @uses TClient::setCliAccountType()
     * @uses TClient::setCliState()
     * @uses TClient::setCliCountry()
     * @uses TClient::setCliTags()
     * @uses TClient::setCliDoNotText()
     * @uses TClient::setCliDoNotEmail()
     * @uses TClient::setCliDoNotPhone()
     * @uses TClient::setCliCashPayment()
     * @uses TClient::setCliLocked()
     * @uses TClient::setCliLanguage()
     * @uses TClient::setProviderCliId()
     * @uses TClient::setCliActive()
     * @uses TClient::setCliVehicleList()
     * @uses TClient::setContactList()
     * @param int $cliId
     * @param string $cliDMSId
     * @param string $cliTitle
     * @param string $cliFamName
     * @param string $cliFirName
     * @param string $cliAddr1
     * @param string $cliAddr2
     * @param string $cliPC
     * @param string $cliCity
     * @param string $cliHomePhone
     * @param string $cliCellPhone
     * @param string $cliWorkPhone
     * @param string $cliFax
     * @param string $cliEmail
     * @param string $cliAccountType
     * @param string $cliState
     * @param string $cliCountry
     * @param string $cliTags
     * @param int $cliDoNotText
     * @param int $cliDoNotEmail
     * @param int $cliDoNotPhone
     * @param int $cliCashPayment
     * @param int $cliLocked
     * @param string $cliLanguage
     * @param string $providerCliId
     * @param int $cliActive
     * @param \StructType\TVehicle[] $cliVehicleList
     * @param \StructType\TContact[] $contactList
     */
    public function __construct($cliId = null, $cliDMSId = null, $cliTitle = null, $cliFamName = null, $cliFirName = null, $cliAddr1 = null, $cliAddr2 = null, $cliPC = null, $cliCity = null, $cliHomePhone = null, $cliCellPhone = null, $cliWorkPhone = null, $cliFax = null, $cliEmail = null, $cliAccountType = null, $cliState = null, $cliCountry = null, $cliTags = null, $cliDoNotText = null, $cliDoNotEmail = null, $cliDoNotPhone = null, $cliCashPayment = null, $cliLocked = null, $cliLanguage = null, $providerCliId = null, $cliActive = null, array $cliVehicleList = array(), array $contactList = array())
    {
        $this
            ->setCliId($cliId)
            ->setCliDMSId($cliDMSId)
            ->setCliTitle($cliTitle)
            ->setCliFamName($cliFamName)
            ->setCliFirName($cliFirName)
            ->setCliAddr1($cliAddr1)
            ->setCliAddr2($cliAddr2)
            ->setCliPC($cliPC)
            ->setCliCity($cliCity)
            ->setCliHomePhone($cliHomePhone)
            ->setCliCellPhone($cliCellPhone)
            ->setCliWorkPhone($cliWorkPhone)
            ->setCliFax($cliFax)
            ->setCliEmail($cliEmail)
            ->setCliAccountType($cliAccountType)
            ->setCliState($cliState)
            ->setCliCountry($cliCountry)
            ->setCliTags($cliTags)
            ->setCliDoNotText($cliDoNotText)
            ->setCliDoNotEmail($cliDoNotEmail)
            ->setCliDoNotPhone($cliDoNotPhone)
            ->setCliCashPayment($cliCashPayment)
            ->setCliLocked($cliLocked)
            ->setCliLanguage($cliLanguage)
            ->setProviderCliId($providerCliId)
            ->setCliActive($cliActive)
            ->setCliVehicleList($cliVehicleList)
            ->setContactList($contactList);
    }
    /**
     * Get CliId value
     * @return int|null
     */
    public function getCliId()
    {
        return $this->CliId;
    }
    /**
     * Set CliId value
     * @param int $cliId
     * @return \StructType\TClient
     */
    public function setCliId($cliId = null)
    {
        // validation for constraint: int
        if (!is_null($cliId) && !is_numeric($cliId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliId)), __LINE__);
        }
        $this->CliId = $cliId;
        return $this;
    }
    /**
     * Get CliDMSId value
     * @return string|null
     */
    public function getCliDMSId()
    {
        return $this->CliDMSId;
    }
    /**
     * Set CliDMSId value
     * @param string $cliDMSId
     * @return \StructType\TClient
     */
    public function setCliDMSId($cliDMSId = null)
    {
        // validation for constraint: string
        if (!is_null($cliDMSId) && !is_string($cliDMSId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliDMSId)), __LINE__);
        }
        $this->CliDMSId = $cliDMSId;
        return $this;
    }
    /**
     * Get CliTitle value
     * @return string|null
     */
    public function getCliTitle()
    {
        return $this->CliTitle;
    }
    /**
     * Set CliTitle value
     * @param string $cliTitle
     * @return \StructType\TClient
     */
    public function setCliTitle($cliTitle = null)
    {
        // validation for constraint: string
        if (!is_null($cliTitle) && !is_string($cliTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliTitle)), __LINE__);
        }
        $this->CliTitle = $cliTitle;
        return $this;
    }
    /**
     * Get CliFamName value
     * @return string|null
     */
    public function getCliFamName()
    {
        return $this->CliFamName;
    }
    /**
     * Set CliFamName value
     * @param string $cliFamName
     * @return \StructType\TClient
     */
    public function setCliFamName($cliFamName = null)
    {
        // validation for constraint: string
        if (!is_null($cliFamName) && !is_string($cliFamName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliFamName)), __LINE__);
        }
        $this->CliFamName = $cliFamName;
        return $this;
    }
    /**
     * Get CliFirName value
     * @return string|null
     */
    public function getCliFirName()
    {
        return $this->CliFirName;
    }
    /**
     * Set CliFirName value
     * @param string $cliFirName
     * @return \StructType\TClient
     */
    public function setCliFirName($cliFirName = null)
    {
        // validation for constraint: string
        if (!is_null($cliFirName) && !is_string($cliFirName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliFirName)), __LINE__);
        }
        $this->CliFirName = $cliFirName;
        return $this;
    }
    /**
     * Get CliAddr1 value
     * @return string|null
     */
    public function getCliAddr1()
    {
        return $this->CliAddr1;
    }
    /**
     * Set CliAddr1 value
     * @param string $cliAddr1
     * @return \StructType\TClient
     */
    public function setCliAddr1($cliAddr1 = null)
    {
        // validation for constraint: string
        if (!is_null($cliAddr1) && !is_string($cliAddr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliAddr1)), __LINE__);
        }
        $this->CliAddr1 = $cliAddr1;
        return $this;
    }
    /**
     * Get CliAddr2 value
     * @return string|null
     */
    public function getCliAddr2()
    {
        return $this->CliAddr2;
    }
    /**
     * Set CliAddr2 value
     * @param string $cliAddr2
     * @return \StructType\TClient
     */
    public function setCliAddr2($cliAddr2 = null)
    {
        // validation for constraint: string
        if (!is_null($cliAddr2) && !is_string($cliAddr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliAddr2)), __LINE__);
        }
        $this->CliAddr2 = $cliAddr2;
        return $this;
    }
    /**
     * Get CliPC value
     * @return string|null
     */
    public function getCliPC()
    {
        return $this->CliPC;
    }
    /**
     * Set CliPC value
     * @param string $cliPC
     * @return \StructType\TClient
     */
    public function setCliPC($cliPC = null)
    {
        // validation for constraint: string
        if (!is_null($cliPC) && !is_string($cliPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliPC)), __LINE__);
        }
        $this->CliPC = $cliPC;
        return $this;
    }
    /**
     * Get CliCity value
     * @return string|null
     */
    public function getCliCity()
    {
        return $this->CliCity;
    }
    /**
     * Set CliCity value
     * @param string $cliCity
     * @return \StructType\TClient
     */
    public function setCliCity($cliCity = null)
    {
        // validation for constraint: string
        if (!is_null($cliCity) && !is_string($cliCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliCity)), __LINE__);
        }
        $this->CliCity = $cliCity;
        return $this;
    }
    /**
     * Get CliHomePhone value
     * @return string|null
     */
    public function getCliHomePhone()
    {
        return $this->CliHomePhone;
    }
    /**
     * Set CliHomePhone value
     * @param string $cliHomePhone
     * @return \StructType\TClient
     */
    public function setCliHomePhone($cliHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($cliHomePhone) && !is_string($cliHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliHomePhone)), __LINE__);
        }
        $this->CliHomePhone = $cliHomePhone;
        return $this;
    }
    /**
     * Get CliCellPhone value
     * @return string|null
     */
    public function getCliCellPhone()
    {
        return $this->CliCellPhone;
    }
    /**
     * Set CliCellPhone value
     * @param string $cliCellPhone
     * @return \StructType\TClient
     */
    public function setCliCellPhone($cliCellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cliCellPhone) && !is_string($cliCellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliCellPhone)), __LINE__);
        }
        $this->CliCellPhone = $cliCellPhone;
        return $this;
    }
    /**
     * Get CliWorkPhone value
     * @return string|null
     */
    public function getCliWorkPhone()
    {
        return $this->CliWorkPhone;
    }
    /**
     * Set CliWorkPhone value
     * @param string $cliWorkPhone
     * @return \StructType\TClient
     */
    public function setCliWorkPhone($cliWorkPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cliWorkPhone) && !is_string($cliWorkPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliWorkPhone)), __LINE__);
        }
        $this->CliWorkPhone = $cliWorkPhone;
        return $this;
    }
    /**
     * Get CliFax value
     * @return string|null
     */
    public function getCliFax()
    {
        return $this->CliFax;
    }
    /**
     * Set CliFax value
     * @param string $cliFax
     * @return \StructType\TClient
     */
    public function setCliFax($cliFax = null)
    {
        // validation for constraint: string
        if (!is_null($cliFax) && !is_string($cliFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliFax)), __LINE__);
        }
        $this->CliFax = $cliFax;
        return $this;
    }
    /**
     * Get CliEmail value
     * @return string|null
     */
    public function getCliEmail()
    {
        return $this->CliEmail;
    }
    /**
     * Set CliEmail value
     * @param string $cliEmail
     * @return \StructType\TClient
     */
    public function setCliEmail($cliEmail = null)
    {
        // validation for constraint: string
        if (!is_null($cliEmail) && !is_string($cliEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliEmail)), __LINE__);
        }
        $this->CliEmail = $cliEmail;
        return $this;
    }
    /**
     * Get CliAccountType value
     * @return string|null
     */
    public function getCliAccountType()
    {
        return $this->CliAccountType;
    }
    /**
     * Set CliAccountType value
     * @param string $cliAccountType
     * @return \StructType\TClient
     */
    public function setCliAccountType($cliAccountType = null)
    {
        // validation for constraint: string
        if (!is_null($cliAccountType) && !is_string($cliAccountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliAccountType)), __LINE__);
        }
        $this->CliAccountType = $cliAccountType;
        return $this;
    }
    /**
     * Get CliState value
     * @return string|null
     */
    public function getCliState()
    {
        return $this->CliState;
    }
    /**
     * Set CliState value
     * @param string $cliState
     * @return \StructType\TClient
     */
    public function setCliState($cliState = null)
    {
        // validation for constraint: string
        if (!is_null($cliState) && !is_string($cliState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliState)), __LINE__);
        }
        $this->CliState = $cliState;
        return $this;
    }
    /**
     * Get CliCountry value
     * @return string|null
     */
    public function getCliCountry()
    {
        return $this->CliCountry;
    }
    /**
     * Set CliCountry value
     * @param string $cliCountry
     * @return \StructType\TClient
     */
    public function setCliCountry($cliCountry = null)
    {
        // validation for constraint: string
        if (!is_null($cliCountry) && !is_string($cliCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliCountry)), __LINE__);
        }
        $this->CliCountry = $cliCountry;
        return $this;
    }
    /**
     * Get CliTags value
     * @return string|null
     */
    public function getCliTags()
    {
        return $this->CliTags;
    }
    /**
     * Set CliTags value
     * @param string $cliTags
     * @return \StructType\TClient
     */
    public function setCliTags($cliTags = null)
    {
        // validation for constraint: string
        if (!is_null($cliTags) && !is_string($cliTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliTags)), __LINE__);
        }
        $this->CliTags = $cliTags;
        return $this;
    }
    /**
     * Get CliDoNotText value
     * @return int|null
     */
    public function getCliDoNotText()
    {
        return $this->CliDoNotText;
    }
    /**
     * Set CliDoNotText value
     * @param int $cliDoNotText
     * @return \StructType\TClient
     */
    public function setCliDoNotText($cliDoNotText = null)
    {
        // validation for constraint: int
        if (!is_null($cliDoNotText) && !is_numeric($cliDoNotText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliDoNotText)), __LINE__);
        }
        $this->CliDoNotText = $cliDoNotText;
        return $this;
    }
    /**
     * Get CliDoNotEmail value
     * @return int|null
     */
    public function getCliDoNotEmail()
    {
        return $this->CliDoNotEmail;
    }
    /**
     * Set CliDoNotEmail value
     * @param int $cliDoNotEmail
     * @return \StructType\TClient
     */
    public function setCliDoNotEmail($cliDoNotEmail = null)
    {
        // validation for constraint: int
        if (!is_null($cliDoNotEmail) && !is_numeric($cliDoNotEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliDoNotEmail)), __LINE__);
        }
        $this->CliDoNotEmail = $cliDoNotEmail;
        return $this;
    }
    /**
     * Get CliDoNotPhone value
     * @return int|null
     */
    public function getCliDoNotPhone()
    {
        return $this->CliDoNotPhone;
    }
    /**
     * Set CliDoNotPhone value
     * @param int $cliDoNotPhone
     * @return \StructType\TClient
     */
    public function setCliDoNotPhone($cliDoNotPhone = null)
    {
        // validation for constraint: int
        if (!is_null($cliDoNotPhone) && !is_numeric($cliDoNotPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliDoNotPhone)), __LINE__);
        }
        $this->CliDoNotPhone = $cliDoNotPhone;
        return $this;
    }
    /**
     * Get CliCashPayment value
     * @return int|null
     */
    public function getCliCashPayment()
    {
        return $this->CliCashPayment;
    }
    /**
     * Set CliCashPayment value
     * @param int $cliCashPayment
     * @return \StructType\TClient
     */
    public function setCliCashPayment($cliCashPayment = null)
    {
        // validation for constraint: int
        if (!is_null($cliCashPayment) && !is_numeric($cliCashPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliCashPayment)), __LINE__);
        }
        $this->CliCashPayment = $cliCashPayment;
        return $this;
    }
    /**
     * Get CliLocked value
     * @return int|null
     */
    public function getCliLocked()
    {
        return $this->CliLocked;
    }
    /**
     * Set CliLocked value
     * @param int $cliLocked
     * @return \StructType\TClient
     */
    public function setCliLocked($cliLocked = null)
    {
        // validation for constraint: int
        if (!is_null($cliLocked) && !is_numeric($cliLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliLocked)), __LINE__);
        }
        $this->CliLocked = $cliLocked;
        return $this;
    }
    /**
     * Get CliLanguage value
     * @return string|null
     */
    public function getCliLanguage()
    {
        return $this->CliLanguage;
    }
    /**
     * Set CliLanguage value
     * @param string $cliLanguage
     * @return \StructType\TClient
     */
    public function setCliLanguage($cliLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($cliLanguage) && !is_string($cliLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cliLanguage)), __LINE__);
        }
        $this->CliLanguage = $cliLanguage;
        return $this;
    }
    /**
     * Get ProviderCliId value
     * @return string|null
     */
    public function getProviderCliId()
    {
        return $this->ProviderCliId;
    }
    /**
     * Set ProviderCliId value
     * @param string $providerCliId
     * @return \StructType\TClient
     */
    public function setProviderCliId($providerCliId = null)
    {
        // validation for constraint: string
        if (!is_null($providerCliId) && !is_string($providerCliId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerCliId)), __LINE__);
        }
        $this->ProviderCliId = $providerCliId;
        return $this;
    }
    /**
     * Get CliActive value
     * @return int|null
     */
    public function getCliActive()
    {
        return $this->CliActive;
    }
    /**
     * Set CliActive value
     * @param int $cliActive
     * @return \StructType\TClient
     */
    public function setCliActive($cliActive = null)
    {
        // validation for constraint: int
        if (!is_null($cliActive) && !is_numeric($cliActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cliActive)), __LINE__);
        }
        $this->CliActive = $cliActive;
        return $this;
    }
    /**
     * Get CliVehicleList value
     * @return \StructType\TVehicle[]|null
     */
    public function getCliVehicleList()
    {
        return $this->CliVehicleList;
    }
    /**
     * Set CliVehicleList value
     * @throws \InvalidArgumentException
     * @param \StructType\TVehicle[] $cliVehicleList
     * @return \StructType\TClient
     */
    public function setCliVehicleList(array $cliVehicleList = array())
    {
        foreach ($cliVehicleList as $tClientCliVehicleListItem) {
            // validation for constraint: itemType
            if (!$tClientCliVehicleListItem instanceof \StructType\TVehicle) {
                throw new \InvalidArgumentException(sprintf('The CliVehicleList property can only contain items of \StructType\TVehicle, "%s" given', is_object($tClientCliVehicleListItem) ? get_class($tClientCliVehicleListItem) : gettype($tClientCliVehicleListItem)), __LINE__);
            }
        }
        $this->CliVehicleList = $cliVehicleList;
        return $this;
    }
    /**
     * Add item to CliVehicleList value
     * @throws \InvalidArgumentException
     * @param \StructType\TVehicle $item
     * @return \StructType\TClient
     */
    public function addToCliVehicleList(\StructType\TVehicle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TVehicle) {
            throw new \InvalidArgumentException(sprintf('The CliVehicleList property can only contain items of \StructType\TVehicle, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CliVehicleList[] = $item;
        return $this;
    }
    /**
     * Get ContactList value
     * @return \StructType\TContact[]|null
     */
    public function getContactList()
    {
        return $this->ContactList;
    }
    /**
     * Set ContactList value
     * @throws \InvalidArgumentException
     * @param \StructType\TContact[] $contactList
     * @return \StructType\TClient
     */
    public function setContactList(array $contactList = array())
    {
        foreach ($contactList as $tClientContactListItem) {
            // validation for constraint: itemType
            if (!$tClientContactListItem instanceof \StructType\TContact) {
                throw new \InvalidArgumentException(sprintf('The ContactList property can only contain items of \StructType\TContact, "%s" given', is_object($tClientContactListItem) ? get_class($tClientContactListItem) : gettype($tClientContactListItem)), __LINE__);
            }
        }
        $this->ContactList = $contactList;
        return $this;
    }
    /**
     * Add item to ContactList value
     * @throws \InvalidArgumentException
     * @param \StructType\TContact $item
     * @return \StructType\TClient
     */
    public function addToContactList(\StructType\TContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TContact) {
            throw new \InvalidArgumentException(sprintf('The ContactList property can only contain items of \StructType\TContact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
