<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TCategoryAction StructType
 * @subpackage Structs
 */
class TCategoryAction extends AbstractStructBase
{
    /**
     * The CategoryActionName
     * @var string
     */
    public $CategoryActionName;
    /**
     * The CategoryActionCode
     * @var string
     */
    public $CategoryActionCode;
    /**
     * The CategoryActionId
     * @var int
     */
    public $CategoryActionId;
    /**
     * Constructor method for TCategoryAction
     * @uses TCategoryAction::setCategoryActionName()
     * @uses TCategoryAction::setCategoryActionCode()
     * @uses TCategoryAction::setCategoryActionId()
     * @param string $categoryActionName
     * @param string $categoryActionCode
     * @param int $categoryActionId
     */
    public function __construct($categoryActionName = null, $categoryActionCode = null, $categoryActionId = null)
    {
        $this
            ->setCategoryActionName($categoryActionName)
            ->setCategoryActionCode($categoryActionCode)
            ->setCategoryActionId($categoryActionId);
    }
    /**
     * Get CategoryActionName value
     * @return string|null
     */
    public function getCategoryActionName()
    {
        return $this->CategoryActionName;
    }
    /**
     * Set CategoryActionName value
     * @param string $categoryActionName
     * @return \StructType\TCategoryAction
     */
    public function setCategoryActionName($categoryActionName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryActionName) && !is_string($categoryActionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryActionName)), __LINE__);
        }
        $this->CategoryActionName = $categoryActionName;
        return $this;
    }
    /**
     * Get CategoryActionCode value
     * @return string|null
     */
    public function getCategoryActionCode()
    {
        return $this->CategoryActionCode;
    }
    /**
     * Set CategoryActionCode value
     * @param string $categoryActionCode
     * @return \StructType\TCategoryAction
     */
    public function setCategoryActionCode($categoryActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryActionCode) && !is_string($categoryActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryActionCode)), __LINE__);
        }
        $this->CategoryActionCode = $categoryActionCode;
        return $this;
    }
    /**
     * Get CategoryActionId value
     * @return int|null
     */
    public function getCategoryActionId()
    {
        return $this->CategoryActionId;
    }
    /**
     * Set CategoryActionId value
     * @param int $categoryActionId
     * @return \StructType\TCategoryAction
     */
    public function setCategoryActionId($categoryActionId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryActionId) && !is_numeric($categoryActionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryActionId)), __LINE__);
        }
        $this->CategoryActionId = $categoryActionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TCategoryAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
