<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAvailabilityTimeSlot StructType
 * @subpackage Structs
 */
class TAvailabilityTimeSlot extends AbstractStructBase
{
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The IsAvailable
     * @var int
     */
    public $IsAvailable;
    /**
     * The IsAvailableOnline
     * @var int
     */
    public $IsAvailableOnline;
    /**
     * Constructor method for TAvailabilityTimeSlot
     * @uses TAvailabilityTimeSlot::setHour()
     * @uses TAvailabilityTimeSlot::setIsAvailable()
     * @uses TAvailabilityTimeSlot::setIsAvailableOnline()
     * @param string $hour
     * @param int $isAvailable
     * @param int $isAvailableOnline
     */
    public function __construct($hour = null, $isAvailable = null, $isAvailableOnline = null)
    {
        $this
            ->setHour($hour)
            ->setIsAvailable($isAvailable)
            ->setIsAvailableOnline($isAvailableOnline);
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\TAvailabilityTimeSlot
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get IsAvailable value
     * @return int|null
     */
    public function getIsAvailable()
    {
        return $this->IsAvailable;
    }
    /**
     * Set IsAvailable value
     * @param int $isAvailable
     * @return \StructType\TAvailabilityTimeSlot
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($isAvailable) && !is_numeric($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isAvailable)), __LINE__);
        }
        $this->IsAvailable = $isAvailable;
        return $this;
    }
    /**
     * Get IsAvailableOnline value
     * @return int|null
     */
    public function getIsAvailableOnline()
    {
        return $this->IsAvailableOnline;
    }
    /**
     * Set IsAvailableOnline value
     * @param int $isAvailableOnline
     * @return \StructType\TAvailabilityTimeSlot
     */
    public function setIsAvailableOnline($isAvailableOnline = null)
    {
        // validation for constraint: int
        if (!is_null($isAvailableOnline) && !is_numeric($isAvailableOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isAvailableOnline)), __LINE__);
        }
        $this->IsAvailableOnline = $isAvailableOnline;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAvailabilityTimeSlot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
