<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkshop StructType
 * @subpackage Structs
 */
class TWorkshop extends AbstractStructBase
{
    /**
     * The WorkshopId
     * @var int
     */
    public $WorkshopId;
    /**
     * The WorkshopName
     * @var string
     */
    public $WorkshopName;
    /**
     * The WorkshopCode
     * @var string
     */
    public $WorkshopCode;
    /**
     * The WorkShopActive
     * @var int
     */
    public $WorkShopActive;
    /**
     * The WorkShopActivationStartDate
     * @var string
     */
    public $WorkShopActivationStartDate;
    /**
     * The WorkShopActivationEndDate
     * @var string
     */
    public $WorkShopActivationEndDate;
    /**
     * The ReceivingList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TReceiving[]
     * - ref: soapenc:arrayType
     * @var \StructType\TReceiving[]
     */
    public $ReceivingList;
    /**
     * The SiteId
     * @var string
     */
    public $SiteId;
    /**
     * The SiteName
     * @var string
     */
    public $SiteName;
    /**
     * Constructor method for TWorkshop
     * @uses TWorkshop::setWorkshopId()
     * @uses TWorkshop::setWorkshopName()
     * @uses TWorkshop::setWorkshopCode()
     * @uses TWorkshop::setWorkShopActive()
     * @uses TWorkshop::setWorkShopActivationStartDate()
     * @uses TWorkshop::setWorkShopActivationEndDate()
     * @uses TWorkshop::setReceivingList()
     * @uses TWorkshop::setSiteId()
     * @uses TWorkshop::setSiteName()
     * @param int $workshopId
     * @param string $workshopName
     * @param string $workshopCode
     * @param int $workShopActive
     * @param string $workShopActivationStartDate
     * @param string $workShopActivationEndDate
     * @param \StructType\TReceiving[] $receivingList
     * @param string $siteId
     * @param string $siteName
     */
    public function __construct($workshopId = null, $workshopName = null, $workshopCode = null, $workShopActive = null, $workShopActivationStartDate = null, $workShopActivationEndDate = null, array $receivingList = array(), $siteId = null, $siteName = null)
    {
        $this
            ->setWorkshopId($workshopId)
            ->setWorkshopName($workshopName)
            ->setWorkshopCode($workshopCode)
            ->setWorkShopActive($workShopActive)
            ->setWorkShopActivationStartDate($workShopActivationStartDate)
            ->setWorkShopActivationEndDate($workShopActivationEndDate)
            ->setReceivingList($receivingList)
            ->setSiteId($siteId)
            ->setSiteName($siteName);
    }
    /**
     * Get WorkshopId value
     * @return int|null
     */
    public function getWorkshopId()
    {
        return $this->WorkshopId;
    }
    /**
     * Set WorkshopId value
     * @param int $workshopId
     * @return \StructType\TWorkshop
     */
    public function setWorkshopId($workshopId = null)
    {
        // validation for constraint: int
        if (!is_null($workshopId) && !is_numeric($workshopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workshopId)), __LINE__);
        }
        $this->WorkshopId = $workshopId;
        return $this;
    }
    /**
     * Get WorkshopName value
     * @return string|null
     */
    public function getWorkshopName()
    {
        return $this->WorkshopName;
    }
    /**
     * Set WorkshopName value
     * @param string $workshopName
     * @return \StructType\TWorkshop
     */
    public function setWorkshopName($workshopName = null)
    {
        // validation for constraint: string
        if (!is_null($workshopName) && !is_string($workshopName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workshopName)), __LINE__);
        }
        $this->WorkshopName = $workshopName;
        return $this;
    }
    /**
     * Get WorkshopCode value
     * @return string|null
     */
    public function getWorkshopCode()
    {
        return $this->WorkshopCode;
    }
    /**
     * Set WorkshopCode value
     * @param string $workshopCode
     * @return \StructType\TWorkshop
     */
    public function setWorkshopCode($workshopCode = null)
    {
        // validation for constraint: string
        if (!is_null($workshopCode) && !is_string($workshopCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workshopCode)), __LINE__);
        }
        $this->WorkshopCode = $workshopCode;
        return $this;
    }
    /**
     * Get WorkShopActive value
     * @return int|null
     */
    public function getWorkShopActive()
    {
        return $this->WorkShopActive;
    }
    /**
     * Set WorkShopActive value
     * @param int $workShopActive
     * @return \StructType\TWorkshop
     */
    public function setWorkShopActive($workShopActive = null)
    {
        // validation for constraint: int
        if (!is_null($workShopActive) && !is_numeric($workShopActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workShopActive)), __LINE__);
        }
        $this->WorkShopActive = $workShopActive;
        return $this;
    }
    /**
     * Get WorkShopActivationStartDate value
     * @return string|null
     */
    public function getWorkShopActivationStartDate()
    {
        return $this->WorkShopActivationStartDate;
    }
    /**
     * Set WorkShopActivationStartDate value
     * @param string $workShopActivationStartDate
     * @return \StructType\TWorkshop
     */
    public function setWorkShopActivationStartDate($workShopActivationStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($workShopActivationStartDate) && !is_string($workShopActivationStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workShopActivationStartDate)), __LINE__);
        }
        $this->WorkShopActivationStartDate = $workShopActivationStartDate;
        return $this;
    }
    /**
     * Get WorkShopActivationEndDate value
     * @return string|null
     */
    public function getWorkShopActivationEndDate()
    {
        return $this->WorkShopActivationEndDate;
    }
    /**
     * Set WorkShopActivationEndDate value
     * @param string $workShopActivationEndDate
     * @return \StructType\TWorkshop
     */
    public function setWorkShopActivationEndDate($workShopActivationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($workShopActivationEndDate) && !is_string($workShopActivationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workShopActivationEndDate)), __LINE__);
        }
        $this->WorkShopActivationEndDate = $workShopActivationEndDate;
        return $this;
    }
    /**
     * Get ReceivingList value
     * @return \StructType\TReceiving[]|null
     */
    public function getReceivingList()
    {
        return $this->ReceivingList;
    }
    /**
     * Set ReceivingList value
     * @throws \InvalidArgumentException
     * @param \StructType\TReceiving[] $receivingList
     * @return \StructType\TWorkshop
     */
    public function setReceivingList(array $receivingList = array())
    {
        foreach ($receivingList as $tWorkshopReceivingListItem) {
            // validation for constraint: itemType
            if (!$tWorkshopReceivingListItem instanceof \StructType\TReceiving) {
                throw new \InvalidArgumentException(sprintf('The ReceivingList property can only contain items of \StructType\TReceiving, "%s" given', is_object($tWorkshopReceivingListItem) ? get_class($tWorkshopReceivingListItem) : gettype($tWorkshopReceivingListItem)), __LINE__);
            }
        }
        $this->ReceivingList = $receivingList;
        return $this;
    }
    /**
     * Add item to ReceivingList value
     * @throws \InvalidArgumentException
     * @param \StructType\TReceiving $item
     * @return \StructType\TWorkshop
     */
    public function addToReceivingList(\StructType\TReceiving $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TReceiving) {
            throw new \InvalidArgumentException(sprintf('The ReceivingList property can only contain items of \StructType\TReceiving, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReceivingList[] = $item;
        return $this;
    }
    /**
     * Get SiteId value
     * @return string|null
     */
    public function getSiteId()
    {
        return $this->SiteId;
    }
    /**
     * Set SiteId value
     * @param string $siteId
     * @return \StructType\TWorkshop
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteId)), __LINE__);
        }
        $this->SiteId = $siteId;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \StructType\TWorkshop
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteName)), __LINE__);
        }
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkshop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
