<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkLine StructType
 * @subpackage Structs
 */
class TWorkLine extends AbstractStructBase
{
    /**
     * The WorkLineNumber
     * @var int
     */
    public $WorkLineNumber;
    /**
     * The WorkLaborCode
     * @var string
     */
    public $WorkLaborCode;
    /**
     * The WorkDescription
     * @var string
     */
    public $WorkDescription;
    /**
     * The WorkComment
     * @var string
     */
    public $WorkComment;
    /**
     * The WorkWarranty
     * @var int
     */
    public $WorkWarranty;
    /**
     * The WorkTechCode
     * @var string
     */
    public $WorkTechCode;
    /**
     * The WorkOperationCodeDms
     * @var string
     */
    public $WorkOperationCodeDms;
    /**
     * The WorkOperationCodeMake
     * @var string
     */
    public $WorkOperationCodeMake;
    /**
     * The WorkOperationCodeEstimate
     * @var string
     */
    public $WorkOperationCodeEstimate;
    /**
     * The WorkHoursSold
     * @var int
     */
    public $WorkHoursSold;
    /**
     * The WorkHoursEstimated
     * @var int
     */
    public $WorkHoursEstimated;
    /**
     * The WorkHoursWorked
     * @var int
     */
    public $WorkHoursWorked;
    /**
     * The WorkLaborCost
     * @var float
     */
    public $WorkLaborCost;
    /**
     * The WorkLaborSale
     * @var float
     */
    public $WorkLaborSale;
    /**
     * The WorkPartsCost
     * @var float
     */
    public $WorkPartsCost;
    /**
     * The WorkPartsSale
     * @var float
     */
    public $WorkPartsSale;
    /**
     * The WorkMiscCost
     * @var float
     */
    public $WorkMiscCost;
    /**
     * The WorkMiscSale
     * @var float
     */
    public $WorkMiscSale;
    /**
     * The WorkReference1
     * @var string
     */
    public $WorkReference1;
    /**
     * The WorkReference2
     * @var string
     */
    public $WorkReference2;
    /**
     * The WorkPartsList
     * @var string
     */
    public $WorkPartsList;
    /**
     * The WorkPartsDesc
     * @var string
     */
    public $WorkPartsDesc;
    /**
     * The WorkActive
     * @var int
     */
    public $WorkActive;
    /**
     * The WorkInitialDemand
     * @var int
     */
    public $WorkInitialDemand;
    /**
     * The WorkAccepted
     * @var int
     */
    public $WorkAccepted;
    /**
     * Constructor method for TWorkLine
     * @uses TWorkLine::setWorkLineNumber()
     * @uses TWorkLine::setWorkLaborCode()
     * @uses TWorkLine::setWorkDescription()
     * @uses TWorkLine::setWorkComment()
     * @uses TWorkLine::setWorkWarranty()
     * @uses TWorkLine::setWorkTechCode()
     * @uses TWorkLine::setWorkOperationCodeDms()
     * @uses TWorkLine::setWorkOperationCodeMake()
     * @uses TWorkLine::setWorkOperationCodeEstimate()
     * @uses TWorkLine::setWorkHoursSold()
     * @uses TWorkLine::setWorkHoursEstimated()
     * @uses TWorkLine::setWorkHoursWorked()
     * @uses TWorkLine::setWorkLaborCost()
     * @uses TWorkLine::setWorkLaborSale()
     * @uses TWorkLine::setWorkPartsCost()
     * @uses TWorkLine::setWorkPartsSale()
     * @uses TWorkLine::setWorkMiscCost()
     * @uses TWorkLine::setWorkMiscSale()
     * @uses TWorkLine::setWorkReference1()
     * @uses TWorkLine::setWorkReference2()
     * @uses TWorkLine::setWorkPartsList()
     * @uses TWorkLine::setWorkPartsDesc()
     * @uses TWorkLine::setWorkActive()
     * @uses TWorkLine::setWorkInitialDemand()
     * @uses TWorkLine::setWorkAccepted()
     * @param int $workLineNumber
     * @param string $workLaborCode
     * @param string $workDescription
     * @param string $workComment
     * @param int $workWarranty
     * @param string $workTechCode
     * @param string $workOperationCodeDms
     * @param string $workOperationCodeMake
     * @param string $workOperationCodeEstimate
     * @param int $workHoursSold
     * @param int $workHoursEstimated
     * @param int $workHoursWorked
     * @param float $workLaborCost
     * @param float $workLaborSale
     * @param float $workPartsCost
     * @param float $workPartsSale
     * @param float $workMiscCost
     * @param float $workMiscSale
     * @param string $workReference1
     * @param string $workReference2
     * @param string $workPartsList
     * @param string $workPartsDesc
     * @param int $workActive
     * @param int $workInitialDemand
     * @param int $workAccepted
     */
    public function __construct($workLineNumber = null, $workLaborCode = null, $workDescription = null, $workComment = null, $workWarranty = null, $workTechCode = null, $workOperationCodeDms = null, $workOperationCodeMake = null, $workOperationCodeEstimate = null, $workHoursSold = null, $workHoursEstimated = null, $workHoursWorked = null, $workLaborCost = null, $workLaborSale = null, $workPartsCost = null, $workPartsSale = null, $workMiscCost = null, $workMiscSale = null, $workReference1 = null, $workReference2 = null, $workPartsList = null, $workPartsDesc = null, $workActive = null, $workInitialDemand = null, $workAccepted = null)
    {
        $this
            ->setWorkLineNumber($workLineNumber)
            ->setWorkLaborCode($workLaborCode)
            ->setWorkDescription($workDescription)
            ->setWorkComment($workComment)
            ->setWorkWarranty($workWarranty)
            ->setWorkTechCode($workTechCode)
            ->setWorkOperationCodeDms($workOperationCodeDms)
            ->setWorkOperationCodeMake($workOperationCodeMake)
            ->setWorkOperationCodeEstimate($workOperationCodeEstimate)
            ->setWorkHoursSold($workHoursSold)
            ->setWorkHoursEstimated($workHoursEstimated)
            ->setWorkHoursWorked($workHoursWorked)
            ->setWorkLaborCost($workLaborCost)
            ->setWorkLaborSale($workLaborSale)
            ->setWorkPartsCost($workPartsCost)
            ->setWorkPartsSale($workPartsSale)
            ->setWorkMiscCost($workMiscCost)
            ->setWorkMiscSale($workMiscSale)
            ->setWorkReference1($workReference1)
            ->setWorkReference2($workReference2)
            ->setWorkPartsList($workPartsList)
            ->setWorkPartsDesc($workPartsDesc)
            ->setWorkActive($workActive)
            ->setWorkInitialDemand($workInitialDemand)
            ->setWorkAccepted($workAccepted);
    }
    /**
     * Get WorkLineNumber value
     * @return int|null
     */
    public function getWorkLineNumber()
    {
        return $this->WorkLineNumber;
    }
    /**
     * Set WorkLineNumber value
     * @param int $workLineNumber
     * @return \StructType\TWorkLine
     */
    public function setWorkLineNumber($workLineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($workLineNumber) && !is_numeric($workLineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workLineNumber)), __LINE__);
        }
        $this->WorkLineNumber = $workLineNumber;
        return $this;
    }
    /**
     * Get WorkLaborCode value
     * @return string|null
     */
    public function getWorkLaborCode()
    {
        return $this->WorkLaborCode;
    }
    /**
     * Set WorkLaborCode value
     * @param string $workLaborCode
     * @return \StructType\TWorkLine
     */
    public function setWorkLaborCode($workLaborCode = null)
    {
        // validation for constraint: string
        if (!is_null($workLaborCode) && !is_string($workLaborCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workLaborCode)), __LINE__);
        }
        $this->WorkLaborCode = $workLaborCode;
        return $this;
    }
    /**
     * Get WorkDescription value
     * @return string|null
     */
    public function getWorkDescription()
    {
        return $this->WorkDescription;
    }
    /**
     * Set WorkDescription value
     * @param string $workDescription
     * @return \StructType\TWorkLine
     */
    public function setWorkDescription($workDescription = null)
    {
        // validation for constraint: string
        if (!is_null($workDescription) && !is_string($workDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workDescription)), __LINE__);
        }
        $this->WorkDescription = $workDescription;
        return $this;
    }
    /**
     * Get WorkComment value
     * @return string|null
     */
    public function getWorkComment()
    {
        return $this->WorkComment;
    }
    /**
     * Set WorkComment value
     * @param string $workComment
     * @return \StructType\TWorkLine
     */
    public function setWorkComment($workComment = null)
    {
        // validation for constraint: string
        if (!is_null($workComment) && !is_string($workComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workComment)), __LINE__);
        }
        $this->WorkComment = $workComment;
        return $this;
    }
    /**
     * Get WorkWarranty value
     * @return int|null
     */
    public function getWorkWarranty()
    {
        return $this->WorkWarranty;
    }
    /**
     * Set WorkWarranty value
     * @param int $workWarranty
     * @return \StructType\TWorkLine
     */
    public function setWorkWarranty($workWarranty = null)
    {
        // validation for constraint: int
        if (!is_null($workWarranty) && !is_numeric($workWarranty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workWarranty)), __LINE__);
        }
        $this->WorkWarranty = $workWarranty;
        return $this;
    }
    /**
     * Get WorkTechCode value
     * @return string|null
     */
    public function getWorkTechCode()
    {
        return $this->WorkTechCode;
    }
    /**
     * Set WorkTechCode value
     * @param string $workTechCode
     * @return \StructType\TWorkLine
     */
    public function setWorkTechCode($workTechCode = null)
    {
        // validation for constraint: string
        if (!is_null($workTechCode) && !is_string($workTechCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workTechCode)), __LINE__);
        }
        $this->WorkTechCode = $workTechCode;
        return $this;
    }
    /**
     * Get WorkOperationCodeDms value
     * @return string|null
     */
    public function getWorkOperationCodeDms()
    {
        return $this->WorkOperationCodeDms;
    }
    /**
     * Set WorkOperationCodeDms value
     * @param string $workOperationCodeDms
     * @return \StructType\TWorkLine
     */
    public function setWorkOperationCodeDms($workOperationCodeDms = null)
    {
        // validation for constraint: string
        if (!is_null($workOperationCodeDms) && !is_string($workOperationCodeDms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workOperationCodeDms)), __LINE__);
        }
        $this->WorkOperationCodeDms = $workOperationCodeDms;
        return $this;
    }
    /**
     * Get WorkOperationCodeMake value
     * @return string|null
     */
    public function getWorkOperationCodeMake()
    {
        return $this->WorkOperationCodeMake;
    }
    /**
     * Set WorkOperationCodeMake value
     * @param string $workOperationCodeMake
     * @return \StructType\TWorkLine
     */
    public function setWorkOperationCodeMake($workOperationCodeMake = null)
    {
        // validation for constraint: string
        if (!is_null($workOperationCodeMake) && !is_string($workOperationCodeMake)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workOperationCodeMake)), __LINE__);
        }
        $this->WorkOperationCodeMake = $workOperationCodeMake;
        return $this;
    }
    /**
     * Get WorkOperationCodeEstimate value
     * @return string|null
     */
    public function getWorkOperationCodeEstimate()
    {
        return $this->WorkOperationCodeEstimate;
    }
    /**
     * Set WorkOperationCodeEstimate value
     * @param string $workOperationCodeEstimate
     * @return \StructType\TWorkLine
     */
    public function setWorkOperationCodeEstimate($workOperationCodeEstimate = null)
    {
        // validation for constraint: string
        if (!is_null($workOperationCodeEstimate) && !is_string($workOperationCodeEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workOperationCodeEstimate)), __LINE__);
        }
        $this->WorkOperationCodeEstimate = $workOperationCodeEstimate;
        return $this;
    }
    /**
     * Get WorkHoursSold value
     * @return int|null
     */
    public function getWorkHoursSold()
    {
        return $this->WorkHoursSold;
    }
    /**
     * Set WorkHoursSold value
     * @param int $workHoursSold
     * @return \StructType\TWorkLine
     */
    public function setWorkHoursSold($workHoursSold = null)
    {
        // validation for constraint: int
        if (!is_null($workHoursSold) && !is_numeric($workHoursSold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workHoursSold)), __LINE__);
        }
        $this->WorkHoursSold = $workHoursSold;
        return $this;
    }
    /**
     * Get WorkHoursEstimated value
     * @return int|null
     */
    public function getWorkHoursEstimated()
    {
        return $this->WorkHoursEstimated;
    }
    /**
     * Set WorkHoursEstimated value
     * @param int $workHoursEstimated
     * @return \StructType\TWorkLine
     */
    public function setWorkHoursEstimated($workHoursEstimated = null)
    {
        // validation for constraint: int
        if (!is_null($workHoursEstimated) && !is_numeric($workHoursEstimated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workHoursEstimated)), __LINE__);
        }
        $this->WorkHoursEstimated = $workHoursEstimated;
        return $this;
    }
    /**
     * Get WorkHoursWorked value
     * @return int|null
     */
    public function getWorkHoursWorked()
    {
        return $this->WorkHoursWorked;
    }
    /**
     * Set WorkHoursWorked value
     * @param int $workHoursWorked
     * @return \StructType\TWorkLine
     */
    public function setWorkHoursWorked($workHoursWorked = null)
    {
        // validation for constraint: int
        if (!is_null($workHoursWorked) && !is_numeric($workHoursWorked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workHoursWorked)), __LINE__);
        }
        $this->WorkHoursWorked = $workHoursWorked;
        return $this;
    }
    /**
     * Get WorkLaborCost value
     * @return float|null
     */
    public function getWorkLaborCost()
    {
        return $this->WorkLaborCost;
    }
    /**
     * Set WorkLaborCost value
     * @param float $workLaborCost
     * @return \StructType\TWorkLine
     */
    public function setWorkLaborCost($workLaborCost = null)
    {
        $this->WorkLaborCost = $workLaborCost;
        return $this;
    }
    /**
     * Get WorkLaborSale value
     * @return float|null
     */
    public function getWorkLaborSale()
    {
        return $this->WorkLaborSale;
    }
    /**
     * Set WorkLaborSale value
     * @param float $workLaborSale
     * @return \StructType\TWorkLine
     */
    public function setWorkLaborSale($workLaborSale = null)
    {
        $this->WorkLaborSale = $workLaborSale;
        return $this;
    }
    /**
     * Get WorkPartsCost value
     * @return float|null
     */
    public function getWorkPartsCost()
    {
        return $this->WorkPartsCost;
    }
    /**
     * Set WorkPartsCost value
     * @param float $workPartsCost
     * @return \StructType\TWorkLine
     */
    public function setWorkPartsCost($workPartsCost = null)
    {
        $this->WorkPartsCost = $workPartsCost;
        return $this;
    }
    /**
     * Get WorkPartsSale value
     * @return float|null
     */
    public function getWorkPartsSale()
    {
        return $this->WorkPartsSale;
    }
    /**
     * Set WorkPartsSale value
     * @param float $workPartsSale
     * @return \StructType\TWorkLine
     */
    public function setWorkPartsSale($workPartsSale = null)
    {
        $this->WorkPartsSale = $workPartsSale;
        return $this;
    }
    /**
     * Get WorkMiscCost value
     * @return float|null
     */
    public function getWorkMiscCost()
    {
        return $this->WorkMiscCost;
    }
    /**
     * Set WorkMiscCost value
     * @param float $workMiscCost
     * @return \StructType\TWorkLine
     */
    public function setWorkMiscCost($workMiscCost = null)
    {
        $this->WorkMiscCost = $workMiscCost;
        return $this;
    }
    /**
     * Get WorkMiscSale value
     * @return float|null
     */
    public function getWorkMiscSale()
    {
        return $this->WorkMiscSale;
    }
    /**
     * Set WorkMiscSale value
     * @param float $workMiscSale
     * @return \StructType\TWorkLine
     */
    public function setWorkMiscSale($workMiscSale = null)
    {
        $this->WorkMiscSale = $workMiscSale;
        return $this;
    }
    /**
     * Get WorkReference1 value
     * @return string|null
     */
    public function getWorkReference1()
    {
        return $this->WorkReference1;
    }
    /**
     * Set WorkReference1 value
     * @param string $workReference1
     * @return \StructType\TWorkLine
     */
    public function setWorkReference1($workReference1 = null)
    {
        // validation for constraint: string
        if (!is_null($workReference1) && !is_string($workReference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workReference1)), __LINE__);
        }
        $this->WorkReference1 = $workReference1;
        return $this;
    }
    /**
     * Get WorkReference2 value
     * @return string|null
     */
    public function getWorkReference2()
    {
        return $this->WorkReference2;
    }
    /**
     * Set WorkReference2 value
     * @param string $workReference2
     * @return \StructType\TWorkLine
     */
    public function setWorkReference2($workReference2 = null)
    {
        // validation for constraint: string
        if (!is_null($workReference2) && !is_string($workReference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workReference2)), __LINE__);
        }
        $this->WorkReference2 = $workReference2;
        return $this;
    }
    /**
     * Get WorkPartsList value
     * @return string|null
     */
    public function getWorkPartsList()
    {
        return $this->WorkPartsList;
    }
    /**
     * Set WorkPartsList value
     * @param string $workPartsList
     * @return \StructType\TWorkLine
     */
    public function setWorkPartsList($workPartsList = null)
    {
        // validation for constraint: string
        if (!is_null($workPartsList) && !is_string($workPartsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPartsList)), __LINE__);
        }
        $this->WorkPartsList = $workPartsList;
        return $this;
    }
    /**
     * Get WorkPartsDesc value
     * @return string|null
     */
    public function getWorkPartsDesc()
    {
        return $this->WorkPartsDesc;
    }
    /**
     * Set WorkPartsDesc value
     * @param string $workPartsDesc
     * @return \StructType\TWorkLine
     */
    public function setWorkPartsDesc($workPartsDesc = null)
    {
        // validation for constraint: string
        if (!is_null($workPartsDesc) && !is_string($workPartsDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPartsDesc)), __LINE__);
        }
        $this->WorkPartsDesc = $workPartsDesc;
        return $this;
    }
    /**
     * Get WorkActive value
     * @return int|null
     */
    public function getWorkActive()
    {
        return $this->WorkActive;
    }
    /**
     * Set WorkActive value
     * @param int $workActive
     * @return \StructType\TWorkLine
     */
    public function setWorkActive($workActive = null)
    {
        // validation for constraint: int
        if (!is_null($workActive) && !is_numeric($workActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workActive)), __LINE__);
        }
        $this->WorkActive = $workActive;
        return $this;
    }
    /**
     * Get WorkInitialDemand value
     * @return int|null
     */
    public function getWorkInitialDemand()
    {
        return $this->WorkInitialDemand;
    }
    /**
     * Set WorkInitialDemand value
     * @param int $workInitialDemand
     * @return \StructType\TWorkLine
     */
    public function setWorkInitialDemand($workInitialDemand = null)
    {
        // validation for constraint: int
        if (!is_null($workInitialDemand) && !is_numeric($workInitialDemand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workInitialDemand)), __LINE__);
        }
        $this->WorkInitialDemand = $workInitialDemand;
        return $this;
    }
    /**
     * Get WorkAccepted value
     * @return int|null
     */
    public function getWorkAccepted()
    {
        return $this->WorkAccepted;
    }
    /**
     * Set WorkAccepted value
     * @param int $workAccepted
     * @return \StructType\TWorkLine
     */
    public function setWorkAccepted($workAccepted = null)
    {
        // validation for constraint: int
        if (!is_null($workAccepted) && !is_numeric($workAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workAccepted)), __LINE__);
        }
        $this->WorkAccepted = $workAccepted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
