<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkFileStatus StructType
 * @subpackage Structs
 */
class TWorkFileStatus extends AbstractStructBase
{
    /**
     * The StatusId
     * @var int
     */
    public $StatusId;
    /**
     * The StatusDateHour
     * @var string
     */
    public $StatusDateHour;
    /**
     * The StatusOn
     * @var int
     */
    public $StatusOn;
    /**
     * The User
     * @var \StructType\TUser
     */
    public $User;
    /**
     * Constructor method for TWorkFileStatus
     * @uses TWorkFileStatus::setStatusId()
     * @uses TWorkFileStatus::setStatusDateHour()
     * @uses TWorkFileStatus::setStatusOn()
     * @uses TWorkFileStatus::setUser()
     * @param int $statusId
     * @param string $statusDateHour
     * @param int $statusOn
     * @param \StructType\TUser $user
     */
    public function __construct($statusId = null, $statusDateHour = null, $statusOn = null, \StructType\TUser $user = null)
    {
        $this
            ->setStatusId($statusId)
            ->setStatusDateHour($statusDateHour)
            ->setStatusOn($statusOn)
            ->setUser($user);
    }
    /**
     * Get StatusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param int $statusId
     * @return \StructType\TWorkFileStatus
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !is_numeric($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusId)), __LINE__);
        }
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Get StatusDateHour value
     * @return string|null
     */
    public function getStatusDateHour()
    {
        return $this->StatusDateHour;
    }
    /**
     * Set StatusDateHour value
     * @param string $statusDateHour
     * @return \StructType\TWorkFileStatus
     */
    public function setStatusDateHour($statusDateHour = null)
    {
        // validation for constraint: string
        if (!is_null($statusDateHour) && !is_string($statusDateHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDateHour)), __LINE__);
        }
        $this->StatusDateHour = $statusDateHour;
        return $this;
    }
    /**
     * Get StatusOn value
     * @return int|null
     */
    public function getStatusOn()
    {
        return $this->StatusOn;
    }
    /**
     * Set StatusOn value
     * @param int $statusOn
     * @return \StructType\TWorkFileStatus
     */
    public function setStatusOn($statusOn = null)
    {
        // validation for constraint: int
        if (!is_null($statusOn) && !is_numeric($statusOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusOn)), __LINE__);
        }
        $this->StatusOn = $statusOn;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\TUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \StructType\TUser $user
     * @return \StructType\TWorkFileStatus
     */
    public function setUser(\StructType\TUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkFileStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
