<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWorkFile StructType
 * @subpackage Structs
 */
class TWorkFile extends AbstractStructBase
{
    /**
     * The Site
     * @var \StructType\TSite
     */
    public $Site;
    /**
     * The Receiving
     * @var \StructType\TReceiving
     */
    public $Receiving;
    /**
     * The Workshop
     * @var \StructType\TWorkshop
     */
    public $Workshop;
    /**
     * The Client
     * @var \StructType\TClient
     */
    public $Client;
    /**
     * The Vehicle
     * @var \StructType\TVehicle
     */
    public $Vehicle;
    /**
     * The WorkFileRdvId
     * @var int
     */
    public $WorkFileRdvId;
    /**
     * The WorkFileRONum
     * @var string
     */
    public $WorkFileRONum;
    /**
     * The WorkFileStart
     * @var string
     */
    public $WorkFileStart;
    /**
     * The WorkFileFinish
     * @var string
     */
    public $WorkFileFinish;
    /**
     * The WorkFileMainWork
     * @var string
     */
    public $WorkFileMainWork;
    /**
     * The WorkFileComment
     * @var string
     */
    public $WorkFileComment;
    /**
     * The WorkFileLoaner
     * @var int
     */
    public $WorkFileLoaner;
    /**
     * The WorkFileTicketNum
     * @var string
     */
    public $WorkFileTicketNum;
    /**
     * The WorkFileActive
     * @var int
     */
    public $WorkFileActive;
    /**
     * The WorkLineList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkLine[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkLine[]
     */
    public $WorkLineList;
    /**
     * The WorkFileBookedOnline
     * @var int
     */
    public $WorkFileBookedOnline;
    /**
     * The WorkFileClientWait
     * @var int
     */
    public $WorkFileClientWait;
    /**
     * The WorkFileIsAppointment
     * @var int
     */
    public $WorkFileIsAppointment;
    /**
     * The WorkFileStoppedVehicle
     * @var int
     */
    public $WorkFileStoppedVehicle;
    /**
     * The StoppedIndicatorList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkFileStatus[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkFileStatus[]
     */
    public $StoppedIndicatorList;
    /**
     * The StatusList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkFileStatus[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkFileStatus[]
     */
    public $StatusList;
    /**
     * The UpsellStatusList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWorkFileStatus[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWorkFileStatus[]
     */
    public $UpsellStatusList;
    /**
     * The WarningList
     * Meta informations extracted from the WSDL
     * - arrayType: ns1:TWarning[]
     * - ref: soapenc:arrayType
     * @var \StructType\TWarning[]
     */
    public $WarningList;
    /**
     * The ProviderRdvId
     * @var string
     */
    public $ProviderRdvId;
    /**
     * The WorkFileTypeId
     * @var int
     */
    public $WorkFileTypeId;
    /**
     * Constructor method for TWorkFile
     * @uses TWorkFile::setSite()
     * @uses TWorkFile::setReceiving()
     * @uses TWorkFile::setWorkshop()
     * @uses TWorkFile::setClient()
     * @uses TWorkFile::setVehicle()
     * @uses TWorkFile::setWorkFileRdvId()
     * @uses TWorkFile::setWorkFileRONum()
     * @uses TWorkFile::setWorkFileStart()
     * @uses TWorkFile::setWorkFileFinish()
     * @uses TWorkFile::setWorkFileMainWork()
     * @uses TWorkFile::setWorkFileComment()
     * @uses TWorkFile::setWorkFileLoaner()
     * @uses TWorkFile::setWorkFileTicketNum()
     * @uses TWorkFile::setWorkFileActive()
     * @uses TWorkFile::setWorkLineList()
     * @uses TWorkFile::setWorkFileBookedOnline()
     * @uses TWorkFile::setWorkFileClientWait()
     * @uses TWorkFile::setWorkFileIsAppointment()
     * @uses TWorkFile::setWorkFileStoppedVehicle()
     * @uses TWorkFile::setStoppedIndicatorList()
     * @uses TWorkFile::setStatusList()
     * @uses TWorkFile::setUpsellStatusList()
     * @uses TWorkFile::setWarningList()
     * @uses TWorkFile::setProviderRdvId()
     * @uses TWorkFile::setWorkFileTypeId()
     * @param \StructType\TSite $site
     * @param \StructType\TReceiving $receiving
     * @param \StructType\TWorkshop $workshop
     * @param \StructType\TClient $client
     * @param \StructType\TVehicle $vehicle
     * @param int $workFileRdvId
     * @param string $workFileRONum
     * @param string $workFileStart
     * @param string $workFileFinish
     * @param string $workFileMainWork
     * @param string $workFileComment
     * @param int $workFileLoaner
     * @param string $workFileTicketNum
     * @param int $workFileActive
     * @param \StructType\TWorkLine[] $workLineList
     * @param int $workFileBookedOnline
     * @param int $workFileClientWait
     * @param int $workFileIsAppointment
     * @param int $workFileStoppedVehicle
     * @param \StructType\TWorkFileStatus[] $stoppedIndicatorList
     * @param \StructType\TWorkFileStatus[] $statusList
     * @param \StructType\TWorkFileStatus[] $upsellStatusList
     * @param \StructType\TWarning[] $warningList
     * @param string $providerRdvId
     * @param int $workFileTypeId
     */
    public function __construct(\StructType\TSite $site = null, \StructType\TReceiving $receiving = null, \StructType\TWorkshop $workshop = null, \StructType\TClient $client = null, \StructType\TVehicle $vehicle = null, $workFileRdvId = null, $workFileRONum = null, $workFileStart = null, $workFileFinish = null, $workFileMainWork = null, $workFileComment = null, $workFileLoaner = null, $workFileTicketNum = null, $workFileActive = null, array $workLineList = array(), $workFileBookedOnline = null, $workFileClientWait = null, $workFileIsAppointment = null, $workFileStoppedVehicle = null, array $stoppedIndicatorList = array(), array $statusList = array(), array $upsellStatusList = array(), array $warningList = array(), $providerRdvId = null, $workFileTypeId = null)
    {
        $this
            ->setSite($site)
            ->setReceiving($receiving)
            ->setWorkshop($workshop)
            ->setClient($client)
            ->setVehicle($vehicle)
            ->setWorkFileRdvId($workFileRdvId)
            ->setWorkFileRONum($workFileRONum)
            ->setWorkFileStart($workFileStart)
            ->setWorkFileFinish($workFileFinish)
            ->setWorkFileMainWork($workFileMainWork)
            ->setWorkFileComment($workFileComment)
            ->setWorkFileLoaner($workFileLoaner)
            ->setWorkFileTicketNum($workFileTicketNum)
            ->setWorkFileActive($workFileActive)
            ->setWorkLineList($workLineList)
            ->setWorkFileBookedOnline($workFileBookedOnline)
            ->setWorkFileClientWait($workFileClientWait)
            ->setWorkFileIsAppointment($workFileIsAppointment)
            ->setWorkFileStoppedVehicle($workFileStoppedVehicle)
            ->setStoppedIndicatorList($stoppedIndicatorList)
            ->setStatusList($statusList)
            ->setUpsellStatusList($upsellStatusList)
            ->setWarningList($warningList)
            ->setProviderRdvId($providerRdvId)
            ->setWorkFileTypeId($workFileTypeId);
    }
    /**
     * Get Site value
     * @return \StructType\TSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\TSite $site
     * @return \StructType\TWorkFile
     */
    public function setSite(\StructType\TSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Receiving value
     * @return \StructType\TReceiving|null
     */
    public function getReceiving()
    {
        return $this->Receiving;
    }
    /**
     * Set Receiving value
     * @param \StructType\TReceiving $receiving
     * @return \StructType\TWorkFile
     */
    public function setReceiving(\StructType\TReceiving $receiving = null)
    {
        $this->Receiving = $receiving;
        return $this;
    }
    /**
     * Get Workshop value
     * @return \StructType\TWorkshop|null
     */
    public function getWorkshop()
    {
        return $this->Workshop;
    }
    /**
     * Set Workshop value
     * @param \StructType\TWorkshop $workshop
     * @return \StructType\TWorkFile
     */
    public function setWorkshop(\StructType\TWorkshop $workshop = null)
    {
        $this->Workshop = $workshop;
        return $this;
    }
    /**
     * Get Client value
     * @return \StructType\TClient|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \StructType\TClient $client
     * @return \StructType\TWorkFile
     */
    public function setClient(\StructType\TClient $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\TVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\TVehicle $vehicle
     * @return \StructType\TWorkFile
     */
    public function setVehicle(\StructType\TVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get WorkFileRdvId value
     * @return int|null
     */
    public function getWorkFileRdvId()
    {
        return $this->WorkFileRdvId;
    }
    /**
     * Set WorkFileRdvId value
     * @param int $workFileRdvId
     * @return \StructType\TWorkFile
     */
    public function setWorkFileRdvId($workFileRdvId = null)
    {
        // validation for constraint: int
        if (!is_null($workFileRdvId) && !is_numeric($workFileRdvId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileRdvId)), __LINE__);
        }
        $this->WorkFileRdvId = $workFileRdvId;
        return $this;
    }
    /**
     * Get WorkFileRONum value
     * @return string|null
     */
    public function getWorkFileRONum()
    {
        return $this->WorkFileRONum;
    }
    /**
     * Set WorkFileRONum value
     * @param string $workFileRONum
     * @return \StructType\TWorkFile
     */
    public function setWorkFileRONum($workFileRONum = null)
    {
        // validation for constraint: string
        if (!is_null($workFileRONum) && !is_string($workFileRONum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileRONum)), __LINE__);
        }
        $this->WorkFileRONum = $workFileRONum;
        return $this;
    }
    /**
     * Get WorkFileStart value
     * @return string|null
     */
    public function getWorkFileStart()
    {
        return $this->WorkFileStart;
    }
    /**
     * Set WorkFileStart value
     * @param string $workFileStart
     * @return \StructType\TWorkFile
     */
    public function setWorkFileStart($workFileStart = null)
    {
        // validation for constraint: string
        if (!is_null($workFileStart) && !is_string($workFileStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileStart)), __LINE__);
        }
        $this->WorkFileStart = $workFileStart;
        return $this;
    }
    /**
     * Get WorkFileFinish value
     * @return string|null
     */
    public function getWorkFileFinish()
    {
        return $this->WorkFileFinish;
    }
    /**
     * Set WorkFileFinish value
     * @param string $workFileFinish
     * @return \StructType\TWorkFile
     */
    public function setWorkFileFinish($workFileFinish = null)
    {
        // validation for constraint: string
        if (!is_null($workFileFinish) && !is_string($workFileFinish)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileFinish)), __LINE__);
        }
        $this->WorkFileFinish = $workFileFinish;
        return $this;
    }
    /**
     * Get WorkFileMainWork value
     * @return string|null
     */
    public function getWorkFileMainWork()
    {
        return $this->WorkFileMainWork;
    }
    /**
     * Set WorkFileMainWork value
     * @param string $workFileMainWork
     * @return \StructType\TWorkFile
     */
    public function setWorkFileMainWork($workFileMainWork = null)
    {
        // validation for constraint: string
        if (!is_null($workFileMainWork) && !is_string($workFileMainWork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileMainWork)), __LINE__);
        }
        $this->WorkFileMainWork = $workFileMainWork;
        return $this;
    }
    /**
     * Get WorkFileComment value
     * @return string|null
     */
    public function getWorkFileComment()
    {
        return $this->WorkFileComment;
    }
    /**
     * Set WorkFileComment value
     * @param string $workFileComment
     * @return \StructType\TWorkFile
     */
    public function setWorkFileComment($workFileComment = null)
    {
        // validation for constraint: string
        if (!is_null($workFileComment) && !is_string($workFileComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileComment)), __LINE__);
        }
        $this->WorkFileComment = $workFileComment;
        return $this;
    }
    /**
     * Get WorkFileLoaner value
     * @return int|null
     */
    public function getWorkFileLoaner()
    {
        return $this->WorkFileLoaner;
    }
    /**
     * Set WorkFileLoaner value
     * @param int $workFileLoaner
     * @return \StructType\TWorkFile
     */
    public function setWorkFileLoaner($workFileLoaner = null)
    {
        // validation for constraint: int
        if (!is_null($workFileLoaner) && !is_numeric($workFileLoaner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileLoaner)), __LINE__);
        }
        $this->WorkFileLoaner = $workFileLoaner;
        return $this;
    }
    /**
     * Get WorkFileTicketNum value
     * @return string|null
     */
    public function getWorkFileTicketNum()
    {
        return $this->WorkFileTicketNum;
    }
    /**
     * Set WorkFileTicketNum value
     * @param string $workFileTicketNum
     * @return \StructType\TWorkFile
     */
    public function setWorkFileTicketNum($workFileTicketNum = null)
    {
        // validation for constraint: string
        if (!is_null($workFileTicketNum) && !is_string($workFileTicketNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workFileTicketNum)), __LINE__);
        }
        $this->WorkFileTicketNum = $workFileTicketNum;
        return $this;
    }
    /**
     * Get WorkFileActive value
     * @return int|null
     */
    public function getWorkFileActive()
    {
        return $this->WorkFileActive;
    }
    /**
     * Set WorkFileActive value
     * @param int $workFileActive
     * @return \StructType\TWorkFile
     */
    public function setWorkFileActive($workFileActive = null)
    {
        // validation for constraint: int
        if (!is_null($workFileActive) && !is_numeric($workFileActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileActive)), __LINE__);
        }
        $this->WorkFileActive = $workFileActive;
        return $this;
    }
    /**
     * Get WorkLineList value
     * @return \StructType\TWorkLine[]|null
     */
    public function getWorkLineList()
    {
        return $this->WorkLineList;
    }
    /**
     * Set WorkLineList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkLine[] $workLineList
     * @return \StructType\TWorkFile
     */
    public function setWorkLineList(array $workLineList = array())
    {
        foreach ($workLineList as $tWorkFileWorkLineListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileWorkLineListItem instanceof \StructType\TWorkLine) {
                throw new \InvalidArgumentException(sprintf('The WorkLineList property can only contain items of \StructType\TWorkLine, "%s" given', is_object($tWorkFileWorkLineListItem) ? get_class($tWorkFileWorkLineListItem) : gettype($tWorkFileWorkLineListItem)), __LINE__);
            }
        }
        $this->WorkLineList = $workLineList;
        return $this;
    }
    /**
     * Add item to WorkLineList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkLine $item
     * @return \StructType\TWorkFile
     */
    public function addToWorkLineList(\StructType\TWorkLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkLine) {
            throw new \InvalidArgumentException(sprintf('The WorkLineList property can only contain items of \StructType\TWorkLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WorkLineList[] = $item;
        return $this;
    }
    /**
     * Get WorkFileBookedOnline value
     * @return int|null
     */
    public function getWorkFileBookedOnline()
    {
        return $this->WorkFileBookedOnline;
    }
    /**
     * Set WorkFileBookedOnline value
     * @param int $workFileBookedOnline
     * @return \StructType\TWorkFile
     */
    public function setWorkFileBookedOnline($workFileBookedOnline = null)
    {
        // validation for constraint: int
        if (!is_null($workFileBookedOnline) && !is_numeric($workFileBookedOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileBookedOnline)), __LINE__);
        }
        $this->WorkFileBookedOnline = $workFileBookedOnline;
        return $this;
    }
    /**
     * Get WorkFileClientWait value
     * @return int|null
     */
    public function getWorkFileClientWait()
    {
        return $this->WorkFileClientWait;
    }
    /**
     * Set WorkFileClientWait value
     * @param int $workFileClientWait
     * @return \StructType\TWorkFile
     */
    public function setWorkFileClientWait($workFileClientWait = null)
    {
        // validation for constraint: int
        if (!is_null($workFileClientWait) && !is_numeric($workFileClientWait)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileClientWait)), __LINE__);
        }
        $this->WorkFileClientWait = $workFileClientWait;
        return $this;
    }
    /**
     * Get WorkFileIsAppointment value
     * @return int|null
     */
    public function getWorkFileIsAppointment()
    {
        return $this->WorkFileIsAppointment;
    }
    /**
     * Set WorkFileIsAppointment value
     * @param int $workFileIsAppointment
     * @return \StructType\TWorkFile
     */
    public function setWorkFileIsAppointment($workFileIsAppointment = null)
    {
        // validation for constraint: int
        if (!is_null($workFileIsAppointment) && !is_numeric($workFileIsAppointment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileIsAppointment)), __LINE__);
        }
        $this->WorkFileIsAppointment = $workFileIsAppointment;
        return $this;
    }
    /**
     * Get WorkFileStoppedVehicle value
     * @return int|null
     */
    public function getWorkFileStoppedVehicle()
    {
        return $this->WorkFileStoppedVehicle;
    }
    /**
     * Set WorkFileStoppedVehicle value
     * @param int $workFileStoppedVehicle
     * @return \StructType\TWorkFile
     */
    public function setWorkFileStoppedVehicle($workFileStoppedVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($workFileStoppedVehicle) && !is_numeric($workFileStoppedVehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileStoppedVehicle)), __LINE__);
        }
        $this->WorkFileStoppedVehicle = $workFileStoppedVehicle;
        return $this;
    }
    /**
     * Get StoppedIndicatorList value
     * @return \StructType\TWorkFileStatus[]|null
     */
    public function getStoppedIndicatorList()
    {
        return $this->StoppedIndicatorList;
    }
    /**
     * Set StoppedIndicatorList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus[] $stoppedIndicatorList
     * @return \StructType\TWorkFile
     */
    public function setStoppedIndicatorList(array $stoppedIndicatorList = array())
    {
        foreach ($stoppedIndicatorList as $tWorkFileStoppedIndicatorListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileStoppedIndicatorListItem instanceof \StructType\TWorkFileStatus) {
                throw new \InvalidArgumentException(sprintf('The StoppedIndicatorList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($tWorkFileStoppedIndicatorListItem) ? get_class($tWorkFileStoppedIndicatorListItem) : gettype($tWorkFileStoppedIndicatorListItem)), __LINE__);
            }
        }
        $this->StoppedIndicatorList = $stoppedIndicatorList;
        return $this;
    }
    /**
     * Add item to StoppedIndicatorList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus $item
     * @return \StructType\TWorkFile
     */
    public function addToStoppedIndicatorList(\StructType\TWorkFileStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkFileStatus) {
            throw new \InvalidArgumentException(sprintf('The StoppedIndicatorList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StoppedIndicatorList[] = $item;
        return $this;
    }
    /**
     * Get StatusList value
     * @return \StructType\TWorkFileStatus[]|null
     */
    public function getStatusList()
    {
        return $this->StatusList;
    }
    /**
     * Set StatusList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus[] $statusList
     * @return \StructType\TWorkFile
     */
    public function setStatusList(array $statusList = array())
    {
        foreach ($statusList as $tWorkFileStatusListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileStatusListItem instanceof \StructType\TWorkFileStatus) {
                throw new \InvalidArgumentException(sprintf('The StatusList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($tWorkFileStatusListItem) ? get_class($tWorkFileStatusListItem) : gettype($tWorkFileStatusListItem)), __LINE__);
            }
        }
        $this->StatusList = $statusList;
        return $this;
    }
    /**
     * Add item to StatusList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus $item
     * @return \StructType\TWorkFile
     */
    public function addToStatusList(\StructType\TWorkFileStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkFileStatus) {
            throw new \InvalidArgumentException(sprintf('The StatusList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StatusList[] = $item;
        return $this;
    }
    /**
     * Get UpsellStatusList value
     * @return \StructType\TWorkFileStatus[]|null
     */
    public function getUpsellStatusList()
    {
        return $this->UpsellStatusList;
    }
    /**
     * Set UpsellStatusList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus[] $upsellStatusList
     * @return \StructType\TWorkFile
     */
    public function setUpsellStatusList(array $upsellStatusList = array())
    {
        foreach ($upsellStatusList as $tWorkFileUpsellStatusListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileUpsellStatusListItem instanceof \StructType\TWorkFileStatus) {
                throw new \InvalidArgumentException(sprintf('The UpsellStatusList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($tWorkFileUpsellStatusListItem) ? get_class($tWorkFileUpsellStatusListItem) : gettype($tWorkFileUpsellStatusListItem)), __LINE__);
            }
        }
        $this->UpsellStatusList = $upsellStatusList;
        return $this;
    }
    /**
     * Add item to UpsellStatusList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWorkFileStatus $item
     * @return \StructType\TWorkFile
     */
    public function addToUpsellStatusList(\StructType\TWorkFileStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWorkFileStatus) {
            throw new \InvalidArgumentException(sprintf('The UpsellStatusList property can only contain items of \StructType\TWorkFileStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UpsellStatusList[] = $item;
        return $this;
    }
    /**
     * Get WarningList value
     * @return \StructType\TWarning[]|null
     */
    public function getWarningList()
    {
        return $this->WarningList;
    }
    /**
     * Set WarningList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWarning[] $warningList
     * @return \StructType\TWorkFile
     */
    public function setWarningList(array $warningList = array())
    {
        foreach ($warningList as $tWorkFileWarningListItem) {
            // validation for constraint: itemType
            if (!$tWorkFileWarningListItem instanceof \StructType\TWarning) {
                throw new \InvalidArgumentException(sprintf('The WarningList property can only contain items of \StructType\TWarning, "%s" given', is_object($tWorkFileWarningListItem) ? get_class($tWorkFileWarningListItem) : gettype($tWorkFileWarningListItem)), __LINE__);
            }
        }
        $this->WarningList = $warningList;
        return $this;
    }
    /**
     * Add item to WarningList value
     * @throws \InvalidArgumentException
     * @param \StructType\TWarning $item
     * @return \StructType\TWorkFile
     */
    public function addToWarningList(\StructType\TWarning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TWarning) {
            throw new \InvalidArgumentException(sprintf('The WarningList property can only contain items of \StructType\TWarning, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarningList[] = $item;
        return $this;
    }
    /**
     * Get ProviderRdvId value
     * @return string|null
     */
    public function getProviderRdvId()
    {
        return $this->ProviderRdvId;
    }
    /**
     * Set ProviderRdvId value
     * @param string $providerRdvId
     * @return \StructType\TWorkFile
     */
    public function setProviderRdvId($providerRdvId = null)
    {
        // validation for constraint: string
        if (!is_null($providerRdvId) && !is_string($providerRdvId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerRdvId)), __LINE__);
        }
        $this->ProviderRdvId = $providerRdvId;
        return $this;
    }
    /**
     * Get WorkFileTypeId value
     * @return int|null
     */
    public function getWorkFileTypeId()
    {
        return $this->WorkFileTypeId;
    }
    /**
     * Set WorkFileTypeId value
     * @param int $workFileTypeId
     * @return \StructType\TWorkFile
     */
    public function setWorkFileTypeId($workFileTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($workFileTypeId) && !is_numeric($workFileTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($workFileTypeId)), __LINE__);
        }
        $this->WorkFileTypeId = $workFileTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWorkFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
