<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TWSResult StructType
 * @subpackage Structs
 */
class TWSResult extends AbstractStructBase
{
    /**
     * The ResultID
     * @var int
     */
    public $ResultID;
    /**
     * The ResultCode
     * @var int
     */
    public $ResultCode;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for TWSResult
     * @uses TWSResult::setResultID()
     * @uses TWSResult::setResultCode()
     * @uses TWSResult::setErrorMessage()
     * @param int $resultID
     * @param int $resultCode
     * @param string $errorMessage
     */
    public function __construct($resultID = null, $resultCode = null, $errorMessage = null)
    {
        $this
            ->setResultID($resultID)
            ->setResultCode($resultCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get ResultID value
     * @return int|null
     */
    public function getResultID()
    {
        return $this->ResultID;
    }
    /**
     * Set ResultID value
     * @param int $resultID
     * @return \StructType\TWSResult
     */
    public function setResultID($resultID = null)
    {
        // validation for constraint: int
        if (!is_null($resultID) && !is_numeric($resultID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultID)), __LINE__);
        }
        $this->ResultID = $resultID;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\TWSResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\TWSResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TWSResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
