<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStoppedIndicator StructType
 * @subpackage Structs
 */
class TStoppedIndicator extends AbstractStructBase
{
    /**
     * The IndicatorName
     * @var string
     */
    public $IndicatorName;
    /**
     * The IndicatorCode
     * @var string
     */
    public $IndicatorCode;
    /**
     * The IndicatorId
     * @var int
     */
    public $IndicatorId;
    /**
     * Constructor method for TStoppedIndicator
     * @uses TStoppedIndicator::setIndicatorName()
     * @uses TStoppedIndicator::setIndicatorCode()
     * @uses TStoppedIndicator::setIndicatorId()
     * @param string $indicatorName
     * @param string $indicatorCode
     * @param int $indicatorId
     */
    public function __construct($indicatorName = null, $indicatorCode = null, $indicatorId = null)
    {
        $this
            ->setIndicatorName($indicatorName)
            ->setIndicatorCode($indicatorCode)
            ->setIndicatorId($indicatorId);
    }
    /**
     * Get IndicatorName value
     * @return string|null
     */
    public function getIndicatorName()
    {
        return $this->IndicatorName;
    }
    /**
     * Set IndicatorName value
     * @param string $indicatorName
     * @return \StructType\TStoppedIndicator
     */
    public function setIndicatorName($indicatorName = null)
    {
        // validation for constraint: string
        if (!is_null($indicatorName) && !is_string($indicatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicatorName)), __LINE__);
        }
        $this->IndicatorName = $indicatorName;
        return $this;
    }
    /**
     * Get IndicatorCode value
     * @return string|null
     */
    public function getIndicatorCode()
    {
        return $this->IndicatorCode;
    }
    /**
     * Set IndicatorCode value
     * @param string $indicatorCode
     * @return \StructType\TStoppedIndicator
     */
    public function setIndicatorCode($indicatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($indicatorCode) && !is_string($indicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicatorCode)), __LINE__);
        }
        $this->IndicatorCode = $indicatorCode;
        return $this;
    }
    /**
     * Get IndicatorId value
     * @return int|null
     */
    public function getIndicatorId()
    {
        return $this->IndicatorId;
    }
    /**
     * Set IndicatorId value
     * @param int $indicatorId
     * @return \StructType\TStoppedIndicator
     */
    public function setIndicatorId($indicatorId = null)
    {
        // validation for constraint: int
        if (!is_null($indicatorId) && !is_numeric($indicatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indicatorId)), __LINE__);
        }
        $this->IndicatorId = $indicatorId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TStoppedIndicator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
