<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TGroupAction StructType
 * @subpackage Structs
 */
class TGroupAction extends AbstractStructBase
{
    /**
     * The GroupActionName
     * @var string
     */
    public $GroupActionName;
    /**
     * The GroupActionId
     * @var int
     */
    public $GroupActionId;
    /**
     * Constructor method for TGroupAction
     * @uses TGroupAction::setGroupActionName()
     * @uses TGroupAction::setGroupActionId()
     * @param string $groupActionName
     * @param int $groupActionId
     */
    public function __construct($groupActionName = null, $groupActionId = null)
    {
        $this
            ->setGroupActionName($groupActionName)
            ->setGroupActionId($groupActionId);
    }
    /**
     * Get GroupActionName value
     * @return string|null
     */
    public function getGroupActionName()
    {
        return $this->GroupActionName;
    }
    /**
     * Set GroupActionName value
     * @param string $groupActionName
     * @return \StructType\TGroupAction
     */
    public function setGroupActionName($groupActionName = null)
    {
        // validation for constraint: string
        if (!is_null($groupActionName) && !is_string($groupActionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupActionName)), __LINE__);
        }
        $this->GroupActionName = $groupActionName;
        return $this;
    }
    /**
     * Get GroupActionId value
     * @return int|null
     */
    public function getGroupActionId()
    {
        return $this->GroupActionId;
    }
    /**
     * Set GroupActionId value
     * @param int $groupActionId
     * @return \StructType\TGroupAction
     */
    public function setGroupActionId($groupActionId = null)
    {
        // validation for constraint: int
        if (!is_null($groupActionId) && !is_numeric($groupActionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupActionId)), __LINE__);
        }
        $this->GroupActionId = $groupActionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TGroupAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
