<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAbsence StructType
 * @subpackage Structs
 */
class TAbsence extends AbstractStructBase
{
    /**
     * The AbsenceId
     * @var int
     */
    public $AbsenceId;
    /**
     * The AbsenceLabel
     * @var string
     */
    public $AbsenceLabel;
    /**
     * Constructor method for TAbsence
     * @uses TAbsence::setAbsenceId()
     * @uses TAbsence::setAbsenceLabel()
     * @param int $absenceId
     * @param string $absenceLabel
     */
    public function __construct($absenceId = null, $absenceLabel = null)
    {
        $this
            ->setAbsenceId($absenceId)
            ->setAbsenceLabel($absenceLabel);
    }
    /**
     * Get AbsenceId value
     * @return int|null
     */
    public function getAbsenceId()
    {
        return $this->AbsenceId;
    }
    /**
     * Set AbsenceId value
     * @param int $absenceId
     * @return \StructType\TAbsence
     */
    public function setAbsenceId($absenceId = null)
    {
        // validation for constraint: int
        if (!is_null($absenceId) && !is_numeric($absenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($absenceId)), __LINE__);
        }
        $this->AbsenceId = $absenceId;
        return $this;
    }
    /**
     * Get AbsenceLabel value
     * @return string|null
     */
    public function getAbsenceLabel()
    {
        return $this->AbsenceLabel;
    }
    /**
     * Set AbsenceLabel value
     * @param string $absenceLabel
     * @return \StructType\TAbsence
     */
    public function setAbsenceLabel($absenceLabel = null)
    {
        // validation for constraint: string
        if (!is_null($absenceLabel) && !is_string($absenceLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($absenceLabel)), __LINE__);
        }
        $this->AbsenceLabel = $absenceLabel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAbsence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
