<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCurrentTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $providerName
     * @return int|bool
     */
    public function getCurrentTicket($entId, $entKey, $dMSId, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getCurrentTicket($entId, $entKey, $dMSId, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUpdatedData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dMSTicket
     * @param string $providerName
     * @return \StructType\TDMSObjects|bool
     */
    public function getUpdatedData($entId, $entKey, $dMSId, $dMSTicket, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getUpdatedData($entId, $entKey, $dMSId, $dMSTicket, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFilesByTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dMSTicket
     * @param string $providerName
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @param string $displayAllUsersUpdates
     * @return \StructType\TWorkFileResult|bool
     */
    public function getWorkFilesByTicket($entId, $entKey, $dMSId, $dMSTicket, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList, $displayAllUsersUpdates)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFilesByTicket($entId, $entKey, $dMSId, $dMSTicket, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList, $displayAllUsersUpdates));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFilesByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @param string $displayStoppedVehicles
     * @return \StructType\TWorkFile[]|bool
     */
    public function getWorkFilesByDate($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList, $displayStoppedVehicles)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFilesByDate($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList, $displayStoppedVehicles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFilesByStatusChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @return \StructType\TWorkFile[]|bool
     */
    public function getWorkFilesByStatusChange($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFilesByStatusChange($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFilesByClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliId
     * @param string $cliName
     * @param string $cliDMSId
     * @param string $vehRegNum
     * @param string $vehVIN
     * @param string $cliTel
     * @param string $cliEmail
     * @param string $providerName
     * @param string $providerCliId
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @return \StructType\TWorkFile[]|bool
     */
    public function getWorkFilesByClient($entId, $entKey, $dMSId, $cliId, $cliName, $cliDMSId, $vehRegNum, $vehVIN, $cliTel, $cliEmail, $providerName, $providerCliId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFilesByClient($entId, $entKey, $dMSId, $cliId, $cliName, $cliDMSId, $vehRegNum, $vehVIN, $cliTel, $cliEmail, $providerName, $providerCliId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFilesByVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $vehRegNum
     * @param string $vehVIN
     * @param string $vehStockNum
     * @param string $providerVehId
     * @param string $vehId
     * @param string $providerName
     * @param string $cliId
     * @param string $cliDMSId
     * @param string $providerCliId
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @return \StructType\TWorkFile[]|bool
     */
    public function getWorkFilesByVehicle($entId, $entKey, $dMSId, $vehRegNum, $vehVIN, $vehStockNum, $providerVehId, $vehId, $providerName, $cliId, $cliDMSId, $providerCliId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFilesByVehicle($entId, $entKey, $dMSId, $vehRegNum, $vehVIN, $vehStockNum, $providerVehId, $vehId, $providerName, $cliId, $cliDMSId, $providerCliId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $rdvId
     * @param string $cliId
     * @param string $vehId
     * @param string $rdvRONum
     * @param string $rdvTicket
     * @param string $providerName
     * @param string $providerCliId
     * @param string $providerVehId
     * @param string $providerRdvId
     * @param string $displayUpsellStatusList
     * @param string $displayStatusList
     * @param string $displayWarningList
     * @param string $displayStoppedIndicatorList
     * @return \StructType\TWorkFile[]|bool
     */
    public function getWorkFile($entId, $entKey, $dMSId, $rdvId, $cliId, $vehId, $rdvRONum, $rdvTicket, $providerName, $providerCliId, $providerVehId, $providerRdvId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFile($entId, $entKey, $dMSId, $rdvId, $cliId, $vehId, $rdvRONum, $rdvTicket, $providerName, $providerCliId, $providerVehId, $providerRdvId, $displayUpsellStatusList, $displayStatusList, $displayWarningList, $displayStoppedIndicatorList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkshopLoad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteCode
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $workShopCode
     * @param string $siteId
     * @param string $workShopId
     * @param string $providerName
     * @return \StructType\TAvailabilityInfo[]|bool
     */
    public function getWorkshopLoad($entId, $entKey, $dMSId, $siteCode, $dateBegin, $dateEnd, $workShopCode, $siteId, $workShopId, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkshopLoad($entId, $entKey, $dMSId, $siteCode, $dateBegin, $dateEnd, $workShopCode, $siteId, $workShopId, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReceptionAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteCode
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $workShopCode
     * @param string $siteId
     * @param string $workshopId
     * @param string $receiverCode
     * @param string $recId
     * @param string $displayDetailed
     * @param string $providerName
     * @param string $displayWithAppt
     * @return \StructType\TReception[]|bool
     */
    public function getReceptionAvailability($entId, $entKey, $dMSId, $siteCode, $dateBegin, $dateEnd, $workShopCode, $siteId, $workshopId, $receiverCode, $recId, $displayDetailed, $providerName, $displayWithAppt)
    {
        try {
            $this->setResult(self::getSoapClient()->getReceptionAvailability($entId, $entKey, $dMSId, $siteCode, $dateBegin, $dateEnd, $workShopCode, $siteId, $workshopId, $receiverCode, $recId, $displayDetailed, $providerName, $displayWithAppt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSiteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $providerName
     * @return \StructType\TSite[]|bool
     */
    public function getSiteList($entId, $entKey, $dMSId, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getSiteList($entId, $entKey, $dMSId, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkshopList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteId
     * @param string $siteCode
     * @param string $providerName
     * @return \StructType\TWorkshop[]|bool
     */
    public function getWorkshopList($entId, $entKey, $dMSId, $siteId, $siteCode, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkshopList($entId, $entKey, $dMSId, $siteId, $siteCode, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReceivingList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteId
     * @param string $siteCode
     * @param string $providerName
     * @return \StructType\TReceiving[]|bool
     */
    public function getReceivingList($entId, $entKey, $dMSId, $siteId, $siteCode, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getReceivingList($entId, $entKey, $dMSId, $siteId, $siteCode, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStatusList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $siteId
     * @param string $siteCode
     * @param string $providerName
     * @param string $workFileTypeId
     * @return \StructType\TStatus[]|bool
     */
    public function getStatusList($entId, $entKey, $dMSId, $codeLanguage, $siteId, $siteCode, $providerName, $workFileTypeId)
    {
        try {
            $this->setResult(self::getSoapClient()->getStatusList($entId, $entKey, $dMSId, $codeLanguage, $siteId, $siteCode, $providerName, $workFileTypeId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUpsellStatusList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $siteId
     * @param string $siteCode
     * @param string $providerName
     * @return \StructType\TStatus[]|bool
     */
    public function getUpsellStatusList($entId, $entKey, $dMSId, $codeLanguage, $siteId, $siteCode, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getUpsellStatusList($entId, $entKey, $dMSId, $codeLanguage, $siteId, $siteCode, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWarningList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TWarning[]|bool
     */
    public function getWarningList($entId, $entKey, $dMSId, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getWarningList($entId, $entKey, $dMSId, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $groupActionId
     * @param string $providerName
     * @param string $vehicleBrand
     * @param string $vehicleModel
     * @param string $siteId
     * @param string $siteCode
     * @return \StructType\TAction[]|bool
     */
    public function getActionList($entId, $entKey, $dMSId, $codeLanguage, $groupActionId, $providerName, $vehicleBrand, $vehicleModel, $siteId, $siteCode)
    {
        try {
            $this->setResult(self::getSoapClient()->getActionList($entId, $entKey, $dMSId, $codeLanguage, $groupActionId, $providerName, $vehicleBrand, $vehicleModel, $siteId, $siteCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupActionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TGroupAction[]|bool
     */
    public function getGroupActionList($entId, $entKey, $dMSId, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getGroupActionList($entId, $entKey, $dMSId, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCategoryActionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TCategoryAction[]|bool
     */
    public function getCategoryActionList($entId, $entKey, $dMSId, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getCategoryActionList($entId, $entKey, $dMSId, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStoppedIndicatorList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TStoppedIndicator[]|bool
     */
    public function getStoppedIndicatorList($entId, $entKey, $dMSId, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getStoppedIndicatorList($entId, $entKey, $dMSId, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @return \StructType\TClient[]|bool
     */
    public function getClientList($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getClientList($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @return \StructType\TVehicle[]|bool
     */
    public function getVehicleList($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleList($entId, $entKey, $dMSId, $dateBegin, $dateEnd, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAbsenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TAbsence[]|bool
     */
    public function getAbsenceList($entId, $entKey, $dMSId, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getAbsenceList($entId, $entKey, $dMSId, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStaffCalendar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteId
     * @param string $siteCode
     * @param string $memId
     * @param string $memCode
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $providerName
     * @return \StructType\TStaffMember[]|bool
     */
    public function getStaffCalendar($entId, $entKey, $dMSId, $siteId, $siteCode, $memId, $memCode, $dateBegin, $dateEnd, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getStaffCalendar($entId, $entKey, $dMSId, $siteId, $siteCode, $memId, $memCode, $dateBegin, $dateEnd, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $cliDMSId
     * @param string $cliLanguage
     * @param string $providerName
     * @param string $providerCliId
     * @param string $cliId
     * @return \StructType\TContact[]|bool
     */
    public function getContactList($entId, $entKey, $dMSId, $cliDMSId, $cliLanguage, $providerName, $providerCliId, $cliId)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactList($entId, $entKey, $dMSId, $cliDMSId, $cliLanguage, $providerName, $providerCliId, $cliId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRegularWeek
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $siteId
     * @param string $siteCode
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TRegularDay[]|bool
     */
    public function getRegularWeek($entId, $entKey, $dMSId, $siteId, $siteCode, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getRegularWeek($entId, $entKey, $dMSId, $siteId, $siteCode, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWorkFileTypeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $entId
     * @param string $entKey
     * @param string $dMSId
     * @param string $softWareID
     * @param string $codeLanguage
     * @param string $providerName
     * @return \StructType\TWorkFileType[]|bool
     */
    public function getWorkFileTypeList($entId, $entKey, $dMSId, $softWareID, $codeLanguage, $providerName)
    {
        try {
            $this->setResult(self::getSoapClient()->getWorkFileTypeList($entId, $entKey, $dMSId, $softWareID, $codeLanguage, $providerName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|\StructType\TAbsence[]|\StructType\TAction[]|\StructType\TAvailabilityInfo[]|\StructType\TCategoryAction[]|\StructType\TClient[]|\StructType\TContact[]|\StructType\TDMSObjects|\StructType\TGroupAction[]|\StructType\TReceiving[]|\StructType\TReception[]|\StructType\TRegularDay[]|\StructType\TSite[]|\StructType\TStaffMember[]|\StructType\TStatus[]|\StructType\TStoppedIndicator[]|\StructType\TVehicle[]|\StructType\TWarning[]|\StructType\TWorkFileResult|\StructType\TWorkFileType[]|\StructType\TWorkFile[]|\StructType\TWorkshop[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
