<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Call ServiceType
 * @subpackage Services
 */
class Call extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CallCourier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CallCourier $parameters
     * @return \StructType\CallCourierResponse|bool
     */
    public function CallCourier(\StructType\CallCourier $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CallCourier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CallCourierResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
