<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQueryJSON StructType
 * @subpackage Structs
 */
class GetQueryJSON extends AbstractStructBase
{
    /**
     * The loginInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $loginInfo;
    /**
     * The queryInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $queryInfo;
    /**
     * Constructor method for GetQueryJSON
     * @uses GetQueryJSON::setLoginInfo()
     * @uses GetQueryJSON::setQueryInfo()
     * @param string $loginInfo
     * @param string $queryInfo
     */
    public function __construct($loginInfo = null, $queryInfo = null)
    {
        $this
            ->setLoginInfo($loginInfo)
            ->setQueryInfo($queryInfo);
    }
    /**
     * Get loginInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginInfo()
    {
        return isset($this->loginInfo) ? $this->loginInfo : null;
    }
    /**
     * Set loginInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginInfo
     * @return \StructType\GetQueryJSON
     */
    public function setLoginInfo($loginInfo = null)
    {
        // validation for constraint: string
        if (!is_null($loginInfo) && !is_string($loginInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginInfo)), __LINE__);
        }
        if (is_null($loginInfo) || (is_array($loginInfo) && empty($loginInfo))) {
            unset($this->loginInfo);
        } else {
            $this->loginInfo = $loginInfo;
        }
        return $this;
    }
    /**
     * Get queryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryInfo()
    {
        return isset($this->queryInfo) ? $this->queryInfo : null;
    }
    /**
     * Set queryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryInfo
     * @return \StructType\GetQueryJSON
     */
    public function setQueryInfo($queryInfo = null)
    {
        // validation for constraint: string
        if (!is_null($queryInfo) && !is_string($queryInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryInfo)), __LINE__);
        }
        if (is_null($queryInfo) || (is_array($queryInfo) && empty($queryInfo))) {
            unset($this->queryInfo);
        } else {
            $this->queryInfo = $queryInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQueryJSON
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
