<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallCourierReturn StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CallCourierReturn
 * @subpackage Structs
 */
class CallCourierReturn extends AbstractStructBase
{
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $result;
    /**
     * The resultMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultMessage;
    /**
     * Constructor method for CallCourierReturn
     * @uses CallCourierReturn::setCount()
     * @uses CallCourierReturn::setResult()
     * @uses CallCourierReturn::setResultMessage()
     * @param int $count
     * @param int $result
     * @param string $resultMessage
     */
    public function __construct($count = null, $result = null, $resultMessage = null)
    {
        $this
            ->setCount($count)
            ->setResult($result)
            ->setResultMessage($resultMessage);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\CallCourierReturn
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get result value
     * @return int|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param int $result
     * @return \StructType\CallCourierReturn
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !is_numeric($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultMessage()
    {
        return isset($this->resultMessage) ? $this->resultMessage : null;
    }
    /**
     * Set resultMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultMessage
     * @return \StructType\CallCourierReturn
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultMessage)), __LINE__);
        }
        if (is_null($resultMessage) || (is_array($resultMessage) && empty($resultMessage))) {
            unset($this->resultMessage);
        } else {
            $this->resultMessage = $resultMessage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallCourierReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
