<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - length: 10
     * @var string
     */
    public $Code;
    /**
     * The DateSOS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 8
     * @var string
     */
    public $DateSOS;
    /**
     * The pdfBase64
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pdfBase64;
    /**
     * The pdfString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pdfString;
    /**
     * The pdfHexBinary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var hexBinary
     */
    public $pdfHexBinary;
    /**
     * The MSU
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * @var string
     */
    public $MSU;
    /**
     * Constructor method for item
     * @uses Item::setCode()
     * @uses Item::setDateSOS()
     * @uses Item::setPdfBase64()
     * @uses Item::setPdfString()
     * @uses Item::setPdfHexBinary()
     * @uses Item::setMSU()
     * @param string $code
     * @param string $dateSOS
     * @param string $pdfBase64
     * @param string $pdfString
     * @param hexBinary $pdfHexBinary
     * @param string $mSU
     */
    public function __construct($code = null, $dateSOS = null, $pdfBase64 = null, $pdfString = null, hexBinary $pdfHexBinary = null, $mSU = null)
    {
        $this
            ->setCode($code)
            ->setDateSOS($dateSOS)
            ->setPdfBase64($pdfBase64)
            ->setPdfString($pdfString)
            ->setPdfHexBinary($pdfHexBinary)
            ->setMSU($mSU);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Item
     */
    public function setCode($code = null)
    {
        // validation for constraint: length
        if ((is_scalar($code) && strlen($code) !== 10) || (is_array($code) && count($code) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DateSOS value
     * @return string|null
     */
    public function getDateSOS()
    {
        return $this->DateSOS;
    }
    /**
     * Set DateSOS value
     * @param string $dateSOS
     * @return \StructType\Item
     */
    public function setDateSOS($dateSOS = null)
    {
        // validation for constraint: length
        if ((is_scalar($dateSOS) && strlen($dateSOS) !== 8) || (is_array($dateSOS) && count($dateSOS) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateSOS) && !is_string($dateSOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateSOS)), __LINE__);
        }
        $this->DateSOS = $dateSOS;
        return $this;
    }
    /**
     * Get pdfBase64 value
     * @return string|null
     */
    public function getPdfBase64()
    {
        return $this->pdfBase64;
    }
    /**
     * Set pdfBase64 value
     * @param string $pdfBase64
     * @return \StructType\Item
     */
    public function setPdfBase64($pdfBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($pdfBase64) && !is_string($pdfBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfBase64)), __LINE__);
        }
        $this->pdfBase64 = $pdfBase64;
        return $this;
    }
    /**
     * Get pdfString value
     * @return string|null
     */
    public function getPdfString()
    {
        return $this->pdfString;
    }
    /**
     * Set pdfString value
     * @param string $pdfString
     * @return \StructType\Item
     */
    public function setPdfString($pdfString = null)
    {
        // validation for constraint: string
        if (!is_null($pdfString) && !is_string($pdfString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfString)), __LINE__);
        }
        $this->pdfString = $pdfString;
        return $this;
    }
    /**
     * Get pdfHexBinary value
     * @return hexBinary|null
     */
    public function getPdfHexBinary()
    {
        return $this->pdfHexBinary;
    }
    /**
     * Set pdfHexBinary value
     * @param hexBinary $pdfHexBinary
     * @return \StructType\Item
     */
    public function setPdfHexBinary(hexBinary $pdfHexBinary = null)
    {
        $this->pdfHexBinary = $pdfHexBinary;
        return $this;
    }
    /**
     * Get MSU value
     * @return string|null
     */
    public function getMSU()
    {
        return $this->MSU;
    }
    /**
     * Set MSU value
     * @param string $mSU
     * @return \StructType\Item
     */
    public function setMSU($mSU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mSU) && strlen($mSU) > 255) || (is_array($mSU) && count($mSU) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($mSU) ? strlen($mSU) : count($mSU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mSU) && !is_string($mSU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mSU)), __LINE__);
        }
        $this->MSU = $mSU;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
