<?php

namespace Sura\Service\Autoclick\EnumType;

/**
 * This class stands for DeducibleAnterior EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleAnterior
 * @subpackage Enumerations
 */
class DeducibleAnterior
{
    /**
     * Constant for value 'CeroUF'
     * @return string 'CeroUF'
     */
    const VALUE_CERO_UF = 'CeroUF';
    /**
     * Constant for value 'TresUF'
     * @return string 'TresUF'
     */
    const VALUE_TRES_UF = 'TresUF';
    /**
     * Constant for value 'CincoUF'
     * @return string 'CincoUF'
     */
    const VALUE_CINCO_UF = 'CincoUF';
    /**
     * Constant for value 'SieteUF'
     * @return string 'SieteUF'
     */
    const VALUE_SIETE_UF = 'SieteUF';
    /**
     * Constant for value 'DiezUF'
     * @return string 'DiezUF'
     */
    const VALUE_DIEZ_UF = 'DiezUF';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERO_UF
     * @uses self::VALUE_TRES_UF
     * @uses self::VALUE_CINCO_UF
     * @uses self::VALUE_SIETE_UF
     * @uses self::VALUE_DIEZ_UF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERO_UF,
            self::VALUE_TRES_UF,
            self::VALUE_CINCO_UF,
            self::VALUE_SIETE_UF,
            self::VALUE_DIEZ_UF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
