<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfertaBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OfertaBase
 * @subpackage Structs
 */
class OfertaBase extends AbstractStructBase
{
    /**
     * The Deducibles
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase
     */
    public $Deducibles;
    /**
     * The codigoProducto
     * @var int
     */
    public $codigoProducto;
    /**
     * The producto
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $producto;
    /**
     * Constructor method for OfertaBase
     * @uses OfertaBase::setDeducibles()
     * @uses OfertaBase::setCodigoProducto()
     * @uses OfertaBase::setProducto()
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase $deducibles
     * @param int $codigoProducto
     * @param string $producto
     */
    public function __construct(\Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase $deducibles = null, $codigoProducto = null, $producto = null)
    {
        $this
            ->setDeducibles($deducibles)
            ->setCodigoProducto($codigoProducto)
            ->setProducto($producto);
    }
    /**
     * Get Deducibles value
     * @return \Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase|null
     */
    public function getDeducibles()
    {
        return $this->Deducibles;
    }
    /**
     * Set Deducibles value
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase $deducibles
     * @return \Sura\Service\Autoclick\StructType\OfertaBase
     */
    public function setDeducibles(\Sura\Service\Autoclick\ArrayType\ArrayOfDeducibleBase $deducibles = null)
    {
        $this->Deducibles = $deducibles;
        return $this;
    }
    /**
     * Get codigoProducto value
     * @return int|null
     */
    public function getCodigoProducto()
    {
        return $this->codigoProducto;
    }
    /**
     * Set codigoProducto value
     * @param int $codigoProducto
     * @return \Sura\Service\Autoclick\StructType\OfertaBase
     */
    public function setCodigoProducto($codigoProducto = null)
    {
        // validation for constraint: int
        if (!is_null($codigoProducto) && !(is_int($codigoProducto) || ctype_digit($codigoProducto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoProducto, true), gettype($codigoProducto)), __LINE__);
        }
        $this->codigoProducto = $codigoProducto;
        return $this;
    }
    /**
     * Get producto value
     * @return string|null
     */
    public function getProducto()
    {
        return $this->producto;
    }
    /**
     * Set producto value
     * @param string $producto
     * @return \Sura\Service\Autoclick\StructType\OfertaBase
     */
    public function setProducto($producto = null)
    {
        // validation for constraint: string
        if (!is_null($producto) && !is_string($producto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producto, true), gettype($producto)), __LINE__);
        }
        $this->producto = $producto;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\OfertaBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
