<?php

namespace Sura\Service\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ConsultaEstadoCotizacion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaEstadoCotizacionRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaEstadoCotizacionResponse|bool
     */
    public function ConsultaEstadoCotizacion(\Sura\Service\Autoclick\StructType\ConsultaEstadoCotizacionRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaEstadoCotizacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaSiniestralidad
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaSiniestralidadRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaSiniestralidadResponse|bool
     */
    public function ConsultaSiniestralidad(\Sura\Service\Autoclick\StructType\ConsultaSiniestralidadRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaSiniestralidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPlanPago
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaPlanPagoRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaPlanPagoResponse|bool
     */
    public function ConsultaPlanPago(\Sura\Service\Autoclick\StructType\ConsultaPlanPagoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPlanPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaContactabilidad
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaContactabilidadRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaContactabilidadResponse|bool
     */
    public function ConsultaContactabilidad(\Sura\Service\Autoclick\StructType\ConsultaContactabilidadRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaContactabilidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaDocumentos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaDocumentosRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaDocumentosResponse|bool
     */
    public function ConsultaDocumentos(\Sura\Service\Autoclick\StructType\ConsultaDocumentosRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDocumentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPolizaIndividual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\ConsultaPolizaIndividual $parameters
     * @return \Sura\Service\Autoclick\StructType\ConsultaPolizaIndividualResponse|bool
     */
    public function ConsultaPolizaIndividual(\Sura\Service\Autoclick\StructType\ConsultaPolizaIndividual $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPolizaIndividual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Service\Autoclick\StructType\ConsultaContactabilidadResponse|\Sura\Service\Autoclick\StructType\ConsultaDocumentosResponse|\Sura\Service\Autoclick\StructType\ConsultaEstadoCotizacionResponse|\Sura\Service\Autoclick\StructType\ConsultaPlanPagoResponse|\Sura\Service\Autoclick\StructType\ConsultaPolizaIndividualResponse|\Sura\Service\Autoclick\StructType\ConsultaSiniestralidadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
