<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaContactabilidadRequest StructType
 * @subpackage Structs
 */
class ConsultaContactabilidadRequest extends AbstractStructBase
{
    /**
     * The NumeroSolicitud
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroSolicitud;
    /**
     * Constructor method for ConsultaContactabilidadRequest
     * @uses ConsultaContactabilidadRequest::setNumeroSolicitud()
     * @param int $numeroSolicitud
     */
    public function __construct($numeroSolicitud = null)
    {
        $this
            ->setNumeroSolicitud($numeroSolicitud);
    }
    /**
     * Get NumeroSolicitud value
     * @return int|null
     */
    public function getNumeroSolicitud()
    {
        return $this->NumeroSolicitud;
    }
    /**
     * Set NumeroSolicitud value
     * @param int $numeroSolicitud
     * @return \Sura\Service\Autoclick\StructType\ConsultaContactabilidadRequest
     */
    public function setNumeroSolicitud($numeroSolicitud = null)
    {
        // validation for constraint: int
        if (!is_null($numeroSolicitud) && !(is_int($numeroSolicitud) || ctype_digit($numeroSolicitud))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroSolicitud, true), gettype($numeroSolicitud)), __LINE__);
        }
        $this->NumeroSolicitud = $numeroSolicitud;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\ConsultaContactabilidadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
