<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaExternaMateriaModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaExternaMateriaModel
 * @subpackage Structs
 */
class PolizaExternaMateriaModel extends AbstractStructBase
{
    /**
     * The ContinuidadCobertura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel
     */
    public $ContinuidadCobertura;
    /**
     * The Factura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel
     */
    public $Factura;
    /**
     * The Inspeccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel
     */
    public $Inspeccion;
    /**
     * The chasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $chasis;
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $color;
    /**
     * The esNuevo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $esNuevo;
    /**
     * The fechaInicioVigencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaInicioVigencia;
    /**
     * The motor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $motor;
    /**
     * The patente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $patente;
    /**
     * The tieneContinuidadCobertura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tieneContinuidadCobertura;
    /**
     * The tieneInspeccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tieneInspeccion;
    /**
     * The tipoVehiculo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoVehiculo;
    /**
     * Constructor method for PolizaExternaMateriaModel
     * @uses PolizaExternaMateriaModel::setContinuidadCobertura()
     * @uses PolizaExternaMateriaModel::setFactura()
     * @uses PolizaExternaMateriaModel::setInspeccion()
     * @uses PolizaExternaMateriaModel::setChasis()
     * @uses PolizaExternaMateriaModel::setColor()
     * @uses PolizaExternaMateriaModel::setEsNuevo()
     * @uses PolizaExternaMateriaModel::setFechaInicioVigencia()
     * @uses PolizaExternaMateriaModel::setMotor()
     * @uses PolizaExternaMateriaModel::setPatente()
     * @uses PolizaExternaMateriaModel::setTieneContinuidadCobertura()
     * @uses PolizaExternaMateriaModel::setTieneInspeccion()
     * @uses PolizaExternaMateriaModel::setTipoVehiculo()
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel $continuidadCobertura
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel $factura
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel $inspeccion
     * @param string $chasis
     * @param string $color
     * @param bool $esNuevo
     * @param string $fechaInicioVigencia
     * @param string $motor
     * @param string $patente
     * @param bool $tieneContinuidadCobertura
     * @param bool $tieneInspeccion
     * @param string $tipoVehiculo
     */
    public function __construct(\Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel $continuidadCobertura = null, \Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel $factura = null, \Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel $inspeccion = null, $chasis = null, $color = null, $esNuevo = null, $fechaInicioVigencia = null, $motor = null, $patente = null, $tieneContinuidadCobertura = null, $tieneInspeccion = null, $tipoVehiculo = null)
    {
        $this
            ->setContinuidadCobertura($continuidadCobertura)
            ->setFactura($factura)
            ->setInspeccion($inspeccion)
            ->setChasis($chasis)
            ->setColor($color)
            ->setEsNuevo($esNuevo)
            ->setFechaInicioVigencia($fechaInicioVigencia)
            ->setMotor($motor)
            ->setPatente($patente)
            ->setTieneContinuidadCobertura($tieneContinuidadCobertura)
            ->setTieneInspeccion($tieneInspeccion)
            ->setTipoVehiculo($tipoVehiculo);
    }
    /**
     * Get ContinuidadCobertura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel|null
     */
    public function getContinuidadCobertura()
    {
        return isset($this->ContinuidadCobertura) ? $this->ContinuidadCobertura : null;
    }
    /**
     * Set ContinuidadCobertura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel $continuidadCobertura
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setContinuidadCobertura(\Sura\Service\Autoclick\StructType\PolizaExternaMateriaContinuidadCoberturaModel $continuidadCobertura = null)
    {
        if (is_null($continuidadCobertura) || (is_array($continuidadCobertura) && empty($continuidadCobertura))) {
            unset($this->ContinuidadCobertura);
        } else {
            $this->ContinuidadCobertura = $continuidadCobertura;
        }
        return $this;
    }
    /**
     * Get Factura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel|null
     */
    public function getFactura()
    {
        return isset($this->Factura) ? $this->Factura : null;
    }
    /**
     * Set Factura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel $factura
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setFactura(\Sura\Service\Autoclick\StructType\PolizaExternaMateriaFacturaModel $factura = null)
    {
        if (is_null($factura) || (is_array($factura) && empty($factura))) {
            unset($this->Factura);
        } else {
            $this->Factura = $factura;
        }
        return $this;
    }
    /**
     * Get Inspeccion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel|null
     */
    public function getInspeccion()
    {
        return isset($this->Inspeccion) ? $this->Inspeccion : null;
    }
    /**
     * Set Inspeccion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel $inspeccion
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setInspeccion(\Sura\Service\Autoclick\StructType\PolizaExternaMateriaInspeccionModel $inspeccion = null)
    {
        if (is_null($inspeccion) || (is_array($inspeccion) && empty($inspeccion))) {
            unset($this->Inspeccion);
        } else {
            $this->Inspeccion = $inspeccion;
        }
        return $this;
    }
    /**
     * Get chasis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChasis()
    {
        return isset($this->chasis) ? $this->chasis : null;
    }
    /**
     * Set chasis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chasis
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setChasis($chasis = null)
    {
        // validation for constraint: string
        if (!is_null($chasis) && !is_string($chasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chasis, true), gettype($chasis)), __LINE__);
        }
        if (is_null($chasis) || (is_array($chasis) && empty($chasis))) {
            unset($this->chasis);
        } else {
            $this->chasis = $chasis;
        }
        return $this;
    }
    /**
     * Get color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColor()
    {
        return isset($this->color) ? $this->color : null;
    }
    /**
     * Set color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $color
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->color);
        } else {
            $this->color = $color;
        }
        return $this;
    }
    /**
     * Get esNuevo value
     * @return bool|null
     */
    public function getEsNuevo()
    {
        return $this->esNuevo;
    }
    /**
     * Set esNuevo value
     * @param bool $esNuevo
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setEsNuevo($esNuevo = null)
    {
        // validation for constraint: boolean
        if (!is_null($esNuevo) && !is_bool($esNuevo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esNuevo, true), gettype($esNuevo)), __LINE__);
        }
        $this->esNuevo = $esNuevo;
        return $this;
    }
    /**
     * Get fechaInicioVigencia value
     * @return string|null
     */
    public function getFechaInicioVigencia()
    {
        return $this->fechaInicioVigencia;
    }
    /**
     * Set fechaInicioVigencia value
     * @param string $fechaInicioVigencia
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setFechaInicioVigencia($fechaInicioVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaInicioVigencia) && !is_string($fechaInicioVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaInicioVigencia, true), gettype($fechaInicioVigencia)), __LINE__);
        }
        $this->fechaInicioVigencia = $fechaInicioVigencia;
        return $this;
    }
    /**
     * Get motor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotor()
    {
        return isset($this->motor) ? $this->motor : null;
    }
    /**
     * Set motor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motor
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setMotor($motor = null)
    {
        // validation for constraint: string
        if (!is_null($motor) && !is_string($motor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motor, true), gettype($motor)), __LINE__);
        }
        if (is_null($motor) || (is_array($motor) && empty($motor))) {
            unset($this->motor);
        } else {
            $this->motor = $motor;
        }
        return $this;
    }
    /**
     * Get patente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatente()
    {
        return isset($this->patente) ? $this->patente : null;
    }
    /**
     * Set patente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $patente
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        if (is_null($patente) || (is_array($patente) && empty($patente))) {
            unset($this->patente);
        } else {
            $this->patente = $patente;
        }
        return $this;
    }
    /**
     * Get tieneContinuidadCobertura value
     * @return bool|null
     */
    public function getTieneContinuidadCobertura()
    {
        return $this->tieneContinuidadCobertura;
    }
    /**
     * Set tieneContinuidadCobertura value
     * @param bool $tieneContinuidadCobertura
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setTieneContinuidadCobertura($tieneContinuidadCobertura = null)
    {
        // validation for constraint: boolean
        if (!is_null($tieneContinuidadCobertura) && !is_bool($tieneContinuidadCobertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tieneContinuidadCobertura, true), gettype($tieneContinuidadCobertura)), __LINE__);
        }
        $this->tieneContinuidadCobertura = $tieneContinuidadCobertura;
        return $this;
    }
    /**
     * Get tieneInspeccion value
     * @return bool|null
     */
    public function getTieneInspeccion()
    {
        return $this->tieneInspeccion;
    }
    /**
     * Set tieneInspeccion value
     * @param bool $tieneInspeccion
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setTieneInspeccion($tieneInspeccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($tieneInspeccion) && !is_bool($tieneInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tieneInspeccion, true), gettype($tieneInspeccion)), __LINE__);
        }
        $this->tieneInspeccion = $tieneInspeccion;
        return $this;
    }
    /**
     * Get tipoVehiculo value
     * @return string|null
     */
    public function getTipoVehiculo()
    {
        return $this->tipoVehiculo;
    }
    /**
     * Set tipoVehiculo value
     * @uses \Sura\Service\Autoclick\EnumType\TipoAuto::valueIsValid()
     * @uses \Sura\Service\Autoclick\EnumType\TipoAuto::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoVehiculo
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public function setTipoVehiculo($tipoVehiculo = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Service\Autoclick\EnumType\TipoAuto::valueIsValid($tipoVehiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Service\Autoclick\EnumType\TipoAuto', is_array($tipoVehiculo) ? implode(', ', $tipoVehiculo) : var_export($tipoVehiculo, true), implode(', ', \Sura\Service\Autoclick\EnumType\TipoAuto::getValidValues())), __LINE__);
        }
        $this->tipoVehiculo = $tipoVehiculo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaMateriaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
