<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Oferta StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Oferta
 * @subpackage Structs
 */
class Oferta extends AbstractStructBase
{
    /**
     * The Deducibles
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Service\Autoclick\ArrayType\ArrayOfDeducible
     */
    public $Deducibles;
    /**
     * The FormasDePago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago
     */
    public $FormasDePago;
    /**
     * The codigoProducto
     * @var int
     */
    public $codigoProducto;
    /**
     * The producto
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $producto;
    /**
     * Constructor method for Oferta
     * @uses Oferta::setDeducibles()
     * @uses Oferta::setFormasDePago()
     * @uses Oferta::setCodigoProducto()
     * @uses Oferta::setProducto()
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfDeducible $deducibles
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago $formasDePago
     * @param int $codigoProducto
     * @param string $producto
     */
    public function __construct(\Sura\Service\Autoclick\ArrayType\ArrayOfDeducible $deducibles = null, \Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago $formasDePago = null, $codigoProducto = null, $producto = null)
    {
        $this
            ->setDeducibles($deducibles)
            ->setFormasDePago($formasDePago)
            ->setCodigoProducto($codigoProducto)
            ->setProducto($producto);
    }
    /**
     * Get Deducibles value
     * @return \Sura\Service\Autoclick\ArrayType\ArrayOfDeducible|null
     */
    public function getDeducibles()
    {
        return $this->Deducibles;
    }
    /**
     * Set Deducibles value
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfDeducible $deducibles
     * @return \Sura\Service\Autoclick\StructType\Oferta
     */
    public function setDeducibles(\Sura\Service\Autoclick\ArrayType\ArrayOfDeducible $deducibles = null)
    {
        $this->Deducibles = $deducibles;
        return $this;
    }
    /**
     * Get FormasDePago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago|null
     */
    public function getFormasDePago()
    {
        return isset($this->FormasDePago) ? $this->FormasDePago : null;
    }
    /**
     * Set FormasDePago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago $formasDePago
     * @return \Sura\Service\Autoclick\StructType\Oferta
     */
    public function setFormasDePago(\Sura\Service\Autoclick\ArrayType\ArrayOfFormaPago $formasDePago = null)
    {
        if (is_null($formasDePago) || (is_array($formasDePago) && empty($formasDePago))) {
            unset($this->FormasDePago);
        } else {
            $this->FormasDePago = $formasDePago;
        }
        return $this;
    }
    /**
     * Get codigoProducto value
     * @return int|null
     */
    public function getCodigoProducto()
    {
        return $this->codigoProducto;
    }
    /**
     * Set codigoProducto value
     * @param int $codigoProducto
     * @return \Sura\Service\Autoclick\StructType\Oferta
     */
    public function setCodigoProducto($codigoProducto = null)
    {
        // validation for constraint: int
        if (!is_null($codigoProducto) && !(is_int($codigoProducto) || ctype_digit($codigoProducto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoProducto, true), gettype($codigoProducto)), __LINE__);
        }
        $this->codigoProducto = $codigoProducto;
        return $this;
    }
    /**
     * Get producto value
     * @return string|null
     */
    public function getProducto()
    {
        return $this->producto;
    }
    /**
     * Set producto value
     * @param string $producto
     * @return \Sura\Service\Autoclick\StructType\Oferta
     */
    public function setProducto($producto = null)
    {
        // validation for constraint: string
        if (!is_null($producto) && !is_string($producto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producto, true), gettype($producto)), __LINE__);
        }
        $this->producto = $producto;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\Oferta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
