<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DatosBase
 * @subpackage Structs
 */
class DatosBase extends AbstractStructBase
{
    /**
     * The Asegurado
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\Asegurado
     */
    public $Asegurado;
    /**
     * The declaraConductorMenor30Anios
     * @var bool
     */
    public $declaraConductorMenor30Anios;
    /**
     * The formaPago
     * @var \Sura\Service\Autoclick\StructType\FormaPago
     */
    public $formaPago;
    /**
     * The recargoDescuento
     * @var string
     */
    public $recargoDescuento;
    /**
     * The valorRecargo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $valorRecargo;
    /**
     * Constructor method for DatosBase
     * @uses DatosBase::setAsegurado()
     * @uses DatosBase::setDeclaraConductorMenor30Anios()
     * @uses DatosBase::setFormaPago()
     * @uses DatosBase::setRecargoDescuento()
     * @uses DatosBase::setValorRecargo()
     * @param \Sura\Service\Autoclick\StructType\Asegurado $asegurado
     * @param bool $declaraConductorMenor30Anios
     * @param \Sura\Service\Autoclick\StructType\FormaPago $formaPago
     * @param string $recargoDescuento
     * @param string $valorRecargo
     */
    public function __construct(\Sura\Service\Autoclick\StructType\Asegurado $asegurado = null, $declaraConductorMenor30Anios = null, \Sura\Service\Autoclick\StructType\FormaPago $formaPago = null, $recargoDescuento = null, $valorRecargo = null)
    {
        $this
            ->setAsegurado($asegurado)
            ->setDeclaraConductorMenor30Anios($declaraConductorMenor30Anios)
            ->setFormaPago($formaPago)
            ->setRecargoDescuento($recargoDescuento)
            ->setValorRecargo($valorRecargo);
    }
    /**
     * Get Asegurado value
     * @return \Sura\Service\Autoclick\StructType\Asegurado|null
     */
    public function getAsegurado()
    {
        return $this->Asegurado;
    }
    /**
     * Set Asegurado value
     * @param \Sura\Service\Autoclick\StructType\Asegurado $asegurado
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public function setAsegurado(\Sura\Service\Autoclick\StructType\Asegurado $asegurado = null)
    {
        $this->Asegurado = $asegurado;
        return $this;
    }
    /**
     * Get declaraConductorMenor30Anios value
     * @return bool|null
     */
    public function getDeclaraConductorMenor30Anios()
    {
        return $this->declaraConductorMenor30Anios;
    }
    /**
     * Set declaraConductorMenor30Anios value
     * @param bool $declaraConductorMenor30Anios
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public function setDeclaraConductorMenor30Anios($declaraConductorMenor30Anios = null)
    {
        // validation for constraint: boolean
        if (!is_null($declaraConductorMenor30Anios) && !is_bool($declaraConductorMenor30Anios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($declaraConductorMenor30Anios, true), gettype($declaraConductorMenor30Anios)), __LINE__);
        }
        $this->declaraConductorMenor30Anios = $declaraConductorMenor30Anios;
        return $this;
    }
    /**
     * Get formaPago value
     * @return \Sura\Service\Autoclick\StructType\FormaPago|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param \Sura\Service\Autoclick\StructType\FormaPago $formaPago
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public function setFormaPago(\Sura\Service\Autoclick\StructType\FormaPago $formaPago = null)
    {
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get recargoDescuento value
     * @return string|null
     */
    public function getRecargoDescuento()
    {
        return $this->recargoDescuento;
    }
    /**
     * Set recargoDescuento value
     * @uses \Sura\Service\Autoclick\EnumType\RecargoDescuento::valueIsValid()
     * @uses \Sura\Service\Autoclick\EnumType\RecargoDescuento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recargoDescuento
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public function setRecargoDescuento($recargoDescuento = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Service\Autoclick\EnumType\RecargoDescuento::valueIsValid($recargoDescuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Service\Autoclick\EnumType\RecargoDescuento', is_array($recargoDescuento) ? implode(', ', $recargoDescuento) : var_export($recargoDescuento, true), implode(', ', \Sura\Service\Autoclick\EnumType\RecargoDescuento::getValidValues())), __LINE__);
        }
        $this->recargoDescuento = $recargoDescuento;
        return $this;
    }
    /**
     * Get valorRecargo value
     * @return string|null
     */
    public function getValorRecargo()
    {
        return $this->valorRecargo;
    }
    /**
     * Set valorRecargo value
     * @param string $valorRecargo
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public function setValorRecargo($valorRecargo = null)
    {
        // validation for constraint: string
        if (!is_null($valorRecargo) && !is_string($valorRecargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valorRecargo, true), gettype($valorRecargo)), __LINE__);
        }
        $this->valorRecargo = $valorRecargo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\DatosBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
