<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaExternaPlanPagoModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaExternaPlanPagoModel
 * @subpackage Structs
 */
class PolizaExternaPlanPagoModel extends AbstractStructBase
{
    /**
     * The PAC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel
     */
    public $PAC;
    /**
     * The PAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel
     */
    public $PAT;
    /**
     * The diaVencimiento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $diaVencimiento;
    /**
     * The formaPago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sura\Service\Autoclick\StructType\FormaPago
     */
    public $formaPago;
    /**
     * The numeroCuotas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCuotas;
    /**
     * Constructor method for PolizaExternaPlanPagoModel
     * @uses PolizaExternaPlanPagoModel::setPAC()
     * @uses PolizaExternaPlanPagoModel::setPAT()
     * @uses PolizaExternaPlanPagoModel::setDiaVencimiento()
     * @uses PolizaExternaPlanPagoModel::setFormaPago()
     * @uses PolizaExternaPlanPagoModel::setNumeroCuotas()
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT
     * @param string $diaVencimiento
     * @param \Sura\Service\Autoclick\StructType\FormaPago $formaPago
     * @param int $numeroCuotas
     */
    public function __construct(\Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC = null, \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT = null, $diaVencimiento = null, \Sura\Service\Autoclick\StructType\FormaPago $formaPago = null, $numeroCuotas = null)
    {
        $this
            ->setPAC($pAC)
            ->setPAT($pAT)
            ->setDiaVencimiento($diaVencimiento)
            ->setFormaPago($formaPago)
            ->setNumeroCuotas($numeroCuotas);
    }
    /**
     * Get PAC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel|null
     */
    public function getPAC()
    {
        return isset($this->PAC) ? $this->PAC : null;
    }
    /**
     * Set PAC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setPAC(\Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPACModel $pAC = null)
    {
        if (is_null($pAC) || (is_array($pAC) && empty($pAC))) {
            unset($this->PAC);
        } else {
            $this->PAC = $pAC;
        }
        return $this;
    }
    /**
     * Get PAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel|null
     */
    public function getPAT()
    {
        return isset($this->PAT) ? $this->PAT : null;
    }
    /**
     * Set PAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setPAT(\Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoPATModel $pAT = null)
    {
        if (is_null($pAT) || (is_array($pAT) && empty($pAT))) {
            unset($this->PAT);
        } else {
            $this->PAT = $pAT;
        }
        return $this;
    }
    /**
     * Get diaVencimiento value
     * @return string|null
     */
    public function getDiaVencimiento()
    {
        return $this->diaVencimiento;
    }
    /**
     * Set diaVencimiento value
     * @uses \Sura\Service\Autoclick\EnumType\DiaPagos::valueIsValid()
     * @uses \Sura\Service\Autoclick\EnumType\DiaPagos::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $diaVencimiento
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setDiaVencimiento($diaVencimiento = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Service\Autoclick\EnumType\DiaPagos::valueIsValid($diaVencimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sura\Service\Autoclick\EnumType\DiaPagos', is_array($diaVencimiento) ? implode(', ', $diaVencimiento) : var_export($diaVencimiento, true), implode(', ', \Sura\Service\Autoclick\EnumType\DiaPagos::getValidValues())), __LINE__);
        }
        $this->diaVencimiento = $diaVencimiento;
        return $this;
    }
    /**
     * Get formaPago value
     * @return \Sura\Service\Autoclick\StructType\FormaPago|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param \Sura\Service\Autoclick\StructType\FormaPago $formaPago
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setFormaPago(\Sura\Service\Autoclick\StructType\FormaPago $formaPago = null)
    {
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get numeroCuotas value
     * @return int|null
     */
    public function getNumeroCuotas()
    {
        return $this->numeroCuotas;
    }
    /**
     * Set numeroCuotas value
     * @param int $numeroCuotas
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public function setNumeroCuotas($numeroCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuotas) && !(is_int($numeroCuotas) || ctype_digit($numeroCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCuotas, true), gettype($numeroCuotas)), __LINE__);
        }
        $this->numeroCuotas = $numeroCuotas;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
