<?php

namespace Sura\Service\Autoclick\EnumType;

/**
 * This class stands for RecargoDescuento EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecargoDescuento
 * @subpackage Enumerations
 */
class RecargoDescuento
{
    /**
     * Constant for value 'Recargo'
     * @return string 'Recargo'
     */
    const VALUE_RECARGO = 'Recargo';
    /**
     * Constant for value 'Descuento'
     * @return string 'Descuento'
     */
    const VALUE_DESCUENTO = 'Descuento';
    /**
     * Constant for value 'NoAplicar'
     * @return string 'NoAplicar'
     */
    const VALUE_NO_APLICAR = 'NoAplicar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RECARGO
     * @uses self::VALUE_DESCUENTO
     * @uses self::VALUE_NO_APLICAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RECARGO,
            self::VALUE_DESCUENTO,
            self::VALUE_NO_APLICAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
