<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asegurado StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Asegurado
 * @subpackage Structs
 */
class Asegurado extends AbstractStructBase
{
    /**
     * The apellidoMaterno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apellidoMaterno;
    /**
     * The apellidoPaterno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apellidoPaterno;
    /**
     * The codigoComuna
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoComuna;
    /**
     * The fechaNacimiento
     * @var string
     */
    public $fechaNacimiento;
    /**
     * The nombres
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nombres;
    /**
     * The razonSocial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $razonSocial;
    /**
     * The rut
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rut;
    /**
     * The tipoPersona
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoPersona;
    /**
     * Constructor method for Asegurado
     * @uses Asegurado::setApellidoMaterno()
     * @uses Asegurado::setApellidoPaterno()
     * @uses Asegurado::setCodigoComuna()
     * @uses Asegurado::setFechaNacimiento()
     * @uses Asegurado::setNombres()
     * @uses Asegurado::setRazonSocial()
     * @uses Asegurado::setRut()
     * @uses Asegurado::setTipoPersona()
     * @param string $apellidoMaterno
     * @param string $apellidoPaterno
     * @param int $codigoComuna
     * @param string $fechaNacimiento
     * @param string $nombres
     * @param string $razonSocial
     * @param string $rut
     * @param string $tipoPersona
     */
    public function __construct($apellidoMaterno = null, $apellidoPaterno = null, $codigoComuna = null, $fechaNacimiento = null, $nombres = null, $razonSocial = null, $rut = null, $tipoPersona = null)
    {
        $this
            ->setApellidoMaterno($apellidoMaterno)
            ->setApellidoPaterno($apellidoPaterno)
            ->setCodigoComuna($codigoComuna)
            ->setFechaNacimiento($fechaNacimiento)
            ->setNombres($nombres)
            ->setRazonSocial($razonSocial)
            ->setRut($rut)
            ->setTipoPersona($tipoPersona);
    }
    /**
     * Get apellidoMaterno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApellidoMaterno()
    {
        return isset($this->apellidoMaterno) ? $this->apellidoMaterno : null;
    }
    /**
     * Set apellidoMaterno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apellidoMaterno
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setApellidoMaterno($apellidoMaterno = null)
    {
        // validation for constraint: string
        if (!is_null($apellidoMaterno) && !is_string($apellidoMaterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apellidoMaterno)), __LINE__);
        }
        if (is_null($apellidoMaterno) || (is_array($apellidoMaterno) && empty($apellidoMaterno))) {
            unset($this->apellidoMaterno);
        } else {
            $this->apellidoMaterno = $apellidoMaterno;
        }
        return $this;
    }
    /**
     * Get apellidoPaterno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApellidoPaterno()
    {
        return isset($this->apellidoPaterno) ? $this->apellidoPaterno : null;
    }
    /**
     * Set apellidoPaterno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apellidoPaterno
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setApellidoPaterno($apellidoPaterno = null)
    {
        // validation for constraint: string
        if (!is_null($apellidoPaterno) && !is_string($apellidoPaterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apellidoPaterno)), __LINE__);
        }
        if (is_null($apellidoPaterno) || (is_array($apellidoPaterno) && empty($apellidoPaterno))) {
            unset($this->apellidoPaterno);
        } else {
            $this->apellidoPaterno = $apellidoPaterno;
        }
        return $this;
    }
    /**
     * Get codigoComuna value
     * @return int|null
     */
    public function getCodigoComuna()
    {
        return $this->codigoComuna;
    }
    /**
     * Set codigoComuna value
     * @param int $codigoComuna
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setCodigoComuna($codigoComuna = null)
    {
        // validation for constraint: int
        if (!is_null($codigoComuna) && !is_numeric($codigoComuna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoComuna)), __LINE__);
        }
        $this->codigoComuna = $codigoComuna;
        return $this;
    }
    /**
     * Get fechaNacimiento value
     * @return string|null
     */
    public function getFechaNacimiento()
    {
        return $this->fechaNacimiento;
    }
    /**
     * Set fechaNacimiento value
     * @param string $fechaNacimiento
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setFechaNacimiento($fechaNacimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechaNacimiento) && !is_string($fechaNacimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaNacimiento)), __LINE__);
        }
        $this->fechaNacimiento = $fechaNacimiento;
        return $this;
    }
    /**
     * Get nombres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNombres()
    {
        return isset($this->nombres) ? $this->nombres : null;
    }
    /**
     * Set nombres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nombres
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setNombres($nombres = null)
    {
        // validation for constraint: string
        if (!is_null($nombres) && !is_string($nombres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombres)), __LINE__);
        }
        if (is_null($nombres) || (is_array($nombres) && empty($nombres))) {
            unset($this->nombres);
        } else {
            $this->nombres = $nombres;
        }
        return $this;
    }
    /**
     * Get razonSocial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRazonSocial()
    {
        return isset($this->razonSocial) ? $this->razonSocial : null;
    }
    /**
     * Set razonSocial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $razonSocial
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setRazonSocial($razonSocial = null)
    {
        // validation for constraint: string
        if (!is_null($razonSocial) && !is_string($razonSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($razonSocial)), __LINE__);
        }
        if (is_null($razonSocial) || (is_array($razonSocial) && empty($razonSocial))) {
            unset($this->razonSocial);
        } else {
            $this->razonSocial = $razonSocial;
        }
        return $this;
    }
    /**
     * Get rut value
     * @return string|null
     */
    public function getRut()
    {
        return $this->rut;
    }
    /**
     * Set rut value
     * @param string $rut
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setRut($rut = null)
    {
        // validation for constraint: string
        if (!is_null($rut) && !is_string($rut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rut)), __LINE__);
        }
        $this->rut = $rut;
        return $this;
    }
    /**
     * Get tipoPersona value
     * @return string|null
     */
    public function getTipoPersona()
    {
        return $this->tipoPersona;
    }
    /**
     * Set tipoPersona value
     * @uses \Sura\Service\Autoclick\EnumType\TipoPersona::valueIsValid()
     * @uses \Sura\Service\Autoclick\EnumType\TipoPersona::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPersona
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public function setTipoPersona($tipoPersona = null)
    {
        // validation for constraint: enumeration
        if (!\Sura\Service\Autoclick\EnumType\TipoPersona::valueIsValid($tipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoPersona, implode(', ', \Sura\Service\Autoclick\EnumType\TipoPersona::getValidValues())), __LINE__);
        }
        $this->tipoPersona = $tipoPersona;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Service\Autoclick\StructType\Asegurado
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
