<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormaPago StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormaPago
 * @subpackage Structs
 */
class FormaPago extends AbstractStructBase
{
    /**
     * The cantidadCuotas
     * @var int
     */
    public $cantidadCuotas;
    /**
     * The formaPago
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $formaPago;
    /**
     * Constructor method for FormaPago
     * @uses FormaPago::setCantidadCuotas()
     * @uses FormaPago::setFormaPago()
     * @param int $cantidadCuotas
     * @param string $formaPago
     */
    public function __construct($cantidadCuotas = null, $formaPago = null)
    {
        $this
            ->setCantidadCuotas($cantidadCuotas)
            ->setFormaPago($formaPago);
    }
    /**
     * Get cantidadCuotas value
     * @return int|null
     */
    public function getCantidadCuotas()
    {
        return $this->cantidadCuotas;
    }
    /**
     * Set cantidadCuotas value
     * @param int $cantidadCuotas
     * @return \Sura\Service\Autoclick\StructType\FormaPago
     */
    public function setCantidadCuotas($cantidadCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadCuotas) && !(is_int($cantidadCuotas) || ctype_digit($cantidadCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadCuotas, true), gettype($cantidadCuotas)), __LINE__);
        }
        $this->cantidadCuotas = $cantidadCuotas;
        return $this;
    }
    /**
     * Get formaPago value
     * @return string|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param string $formaPago
     * @return \Sura\Service\Autoclick\StructType\FormaPago
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: string
        if (!is_null($formaPago) && !is_string($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formaPago, true), gettype($formaPago)), __LINE__);
        }
        $this->formaPago = $formaPago;
        return $this;
    }
}
