<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmitirPolizaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmitirPolizaModel
 * @subpackage Structs
 */
class EmitirPolizaModel extends AbstractStructBase
{
    /**
     * The InfoPoliza
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaModel
     */
    public $InfoPoliza;
    /**
     * The cotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $cotizacionServicioID;
    /**
     * Constructor method for EmitirPolizaModel
     * @uses EmitirPolizaModel::setInfoPoliza()
     * @uses EmitirPolizaModel::setCotizacionServicioID()
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaModel $infoPoliza
     * @param string $cotizacionServicioID
     */
    public function __construct(\Sura\Service\Autoclick\StructType\PolizaExternaModel $infoPoliza = null, $cotizacionServicioID = null)
    {
        $this
            ->setInfoPoliza($infoPoliza)
            ->setCotizacionServicioID($cotizacionServicioID);
    }
    /**
     * Get InfoPoliza value
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaModel|null
     */
    public function getInfoPoliza()
    {
        return $this->InfoPoliza;
    }
    /**
     * Set InfoPoliza value
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaModel $infoPoliza
     * @return \Sura\Service\Autoclick\StructType\EmitirPolizaModel
     */
    public function setInfoPoliza(\Sura\Service\Autoclick\StructType\PolizaExternaModel $infoPoliza = null)
    {
        $this->InfoPoliza = $infoPoliza;
        return $this;
    }
    /**
     * Get cotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->cotizacionServicioID;
    }
    /**
     * Set cotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \Sura\Service\Autoclick\StructType\EmitirPolizaModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->cotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
}
