<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmitirPolizaHubModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmitirPolizaHubModel
 * @subpackage Structs
 */
class EmitirPolizaHubModel extends AbstractStructBase
{
    /**
     * The PlanPago
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel
     */
    public $PlanPago;
    /**
     * The cotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $cotizacionServicioID;
    /**
     * Constructor method for EmitirPolizaHubModel
     * @uses EmitirPolizaHubModel::setPlanPago()
     * @uses EmitirPolizaHubModel::setCotizacionServicioID()
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel $planPago
     * @param string $cotizacionServicioID
     */
    public function __construct(\Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel $planPago = null, $cotizacionServicioID = null)
    {
        $this
            ->setPlanPago($planPago)
            ->setCotizacionServicioID($cotizacionServicioID);
    }
    /**
     * Get PlanPago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel|null
     */
    public function getPlanPago()
    {
        return isset($this->PlanPago) ? $this->PlanPago : null;
    }
    /**
     * Set PlanPago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel $planPago
     * @return \Sura\Service\Autoclick\StructType\EmitirPolizaHubModel
     */
    public function setPlanPago(\Sura\Service\Autoclick\StructType\PolizaExternaPlanPagoModel $planPago = null)
    {
        if (is_null($planPago) || (is_array($planPago) && empty($planPago))) {
            unset($this->PlanPago);
        } else {
            $this->PlanPago = $planPago;
        }
        return $this;
    }
    /**
     * Get cotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->cotizacionServicioID;
    }
    /**
     * Set cotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \Sura\Service\Autoclick\StructType\EmitirPolizaHubModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->cotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
}
