<?php

namespace Sura\Service\Autoclick\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleCobertura StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleCobertura
 * @subpackage Structs
 */
class DeducibleCobertura extends AbstractStructBase
{
    /**
     * The cobertura
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cobertura;
    /**
     * The esExenta
     * @var bool
     */
    public $esExenta;
    /**
     * The montoAsegurado
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $montoAsegurado;
    /**
     * Constructor method for DeducibleCobertura
     * @uses DeducibleCobertura::setCobertura()
     * @uses DeducibleCobertura::setEsExenta()
     * @uses DeducibleCobertura::setMontoAsegurado()
     * @param string $cobertura
     * @param bool $esExenta
     * @param string $montoAsegurado
     */
    public function __construct($cobertura = null, $esExenta = null, $montoAsegurado = null)
    {
        $this
            ->setCobertura($cobertura)
            ->setEsExenta($esExenta)
            ->setMontoAsegurado($montoAsegurado);
    }
    /**
     * Get cobertura value
     * @return string|null
     */
    public function getCobertura()
    {
        return $this->cobertura;
    }
    /**
     * Set cobertura value
     * @param string $cobertura
     * @return \Sura\Service\Autoclick\StructType\DeducibleCobertura
     */
    public function setCobertura($cobertura = null)
    {
        // validation for constraint: string
        if (!is_null($cobertura) && !is_string($cobertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cobertura, true), gettype($cobertura)), __LINE__);
        }
        $this->cobertura = $cobertura;
        return $this;
    }
    /**
     * Get esExenta value
     * @return bool|null
     */
    public function getEsExenta()
    {
        return $this->esExenta;
    }
    /**
     * Set esExenta value
     * @param bool $esExenta
     * @return \Sura\Service\Autoclick\StructType\DeducibleCobertura
     */
    public function setEsExenta($esExenta = null)
    {
        // validation for constraint: boolean
        if (!is_null($esExenta) && !is_bool($esExenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esExenta, true), gettype($esExenta)), __LINE__);
        }
        $this->esExenta = $esExenta;
        return $this;
    }
    /**
     * Get montoAsegurado value
     * @return string|null
     */
    public function getMontoAsegurado()
    {
        return $this->montoAsegurado;
    }
    /**
     * Set montoAsegurado value
     * @param string $montoAsegurado
     * @return \Sura\Service\Autoclick\StructType\DeducibleCobertura
     */
    public function setMontoAsegurado($montoAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($montoAsegurado) && !is_string($montoAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($montoAsegurado, true), gettype($montoAsegurado)), __LINE__);
        }
        $this->montoAsegurado = $montoAsegurado;
        return $this;
    }
}
