<?php

namespace Sura\Service\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotiza ServiceType
 * @subpackage Services
 */
class Cotiza extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CotizaOfertaKilometros
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionOfertaKilometroResponse|bool
     */
    public function CotizaOfertaKilometros(\Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaKilometros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOferta
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionOfertaResponse|bool
     */
    public function CotizaOferta(\Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOferta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProducto
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionProductoResponse|bool
     */
    public function CotizaProducto(\Sura\Service\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaProductoBase
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaProductoRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionProductoBaseResponse|bool
     */
    public function CotizaProductoBase(\Sura\Service\Autoclick\StructType\CotizaProductoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaProductoBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBase
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBase(\Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaBase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizaOfertaBaseFalabella
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\CotizacionOfertaBaseResponse|bool
     */
    public function CotizaOfertaBaseFalabella(\Sura\Service\Autoclick\StructType\CotizaOfertaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizaOfertaBaseFalabella($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Service\Autoclick\StructType\CotizacionOfertaBaseResponse|\Sura\Service\Autoclick\StructType\CotizacionOfertaKilometroResponse|\Sura\Service\Autoclick\StructType\CotizacionOfertaResponse|\Sura\Service\Autoclick\StructType\CotizacionProductoBaseResponse|\Sura\Service\Autoclick\StructType\CotizacionProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
