<?php

namespace Sura\Service\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Solicitar ServiceType
 * @subpackage Services
 */
class Solicitar extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Service\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SolicitarPoliza
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Service\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Service\Autoclick\StructType\GeneraPolizaRequest $parameters
     * @return \Sura\Service\Autoclick\StructType\GeneraPolizaResponse|bool
     */
    public function SolicitarPoliza(\Sura\Service\Autoclick\StructType\GeneraPolizaRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SolicitarPoliza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Service\Autoclick\StructType\GeneraPolizaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
