<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTLRequest StructType
 * @subpackage Structs
 */
class LTLRequest extends AbstractStructBase
{
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShipmentDate;
    /**
     * The Miles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Miles;
    /**
     * The IsBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBatch;
    /**
     * The TotalLFT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalLFT;
    /**
     * The OrigZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrigZip;
    /**
     * The OrigCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrigCity;
    /**
     * The OrigState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrigState;
    /**
     * The OrigCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrigCountry;
    /**
     * The DestZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestZip;
    /**
     * The DestCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestCity;
    /**
     * The DestState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestState;
    /**
     * The DestCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestCountry;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShipment
     */
    public $Shipments;
    /**
     * The AccessorialCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AccessorialCodes;
    /**
     * The ProfileCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileCode;
    /**
     * The ClientCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The SrvToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SrvToken;
    /**
     * The UsrToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsrToken;
    /**
     * The SCAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SCAC;
    /**
     * The ZoneCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZoneCode;
    /**
     * The ServiceLevelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceLevelCode;
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Route;
    /**
     * The LCC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LCC;
    /**
     * Constructor method for LTLRequest
     * @uses LTLRequest::setShipmentDate()
     * @uses LTLRequest::setMiles()
     * @uses LTLRequest::setIsBatch()
     * @uses LTLRequest::setTotalLFT()
     * @uses LTLRequest::setOrigZip()
     * @uses LTLRequest::setOrigCity()
     * @uses LTLRequest::setOrigState()
     * @uses LTLRequest::setOrigCountry()
     * @uses LTLRequest::setDestZip()
     * @uses LTLRequest::setDestCity()
     * @uses LTLRequest::setDestState()
     * @uses LTLRequest::setDestCountry()
     * @uses LTLRequest::setShipments()
     * @uses LTLRequest::setAccessorialCodes()
     * @uses LTLRequest::setProfileCode()
     * @uses LTLRequest::setClientCode()
     * @uses LTLRequest::setSrvToken()
     * @uses LTLRequest::setUsrToken()
     * @uses LTLRequest::setSCAC()
     * @uses LTLRequest::setZoneCode()
     * @uses LTLRequest::setServiceLevelCode()
     * @uses LTLRequest::setRoute()
     * @uses LTLRequest::setLCC()
     * @param string $shipmentDate
     * @param float $miles
     * @param bool $isBatch
     * @param float $totalLFT
     * @param string $origZip
     * @param string $origCity
     * @param string $origState
     * @param string $origCountry
     * @param string $destZip
     * @param string $destCity
     * @param string $destState
     * @param string $destCountry
     * @param \ArrayType\ArrayOfShipment $shipments
     * @param \ArrayType\ArrayOfString $accessorialCodes
     * @param string $profileCode
     * @param string $clientCode
     * @param string $srvToken
     * @param string $usrToken
     * @param string $sCAC
     * @param string $zoneCode
     * @param string $serviceLevelCode
     * @param string $route
     * @param string $lCC
     */
    public function __construct($shipmentDate = null, $miles = null, $isBatch = null, $totalLFT = null, $origZip = null, $origCity = null, $origState = null, $origCountry = null, $destZip = null, $destCity = null, $destState = null, $destCountry = null, \ArrayType\ArrayOfShipment $shipments = null, \ArrayType\ArrayOfString $accessorialCodes = null, $profileCode = null, $clientCode = null, $srvToken = null, $usrToken = null, $sCAC = null, $zoneCode = null, $serviceLevelCode = null, $route = null, $lCC = null)
    {
        $this
            ->setShipmentDate($shipmentDate)
            ->setMiles($miles)
            ->setIsBatch($isBatch)
            ->setTotalLFT($totalLFT)
            ->setOrigZip($origZip)
            ->setOrigCity($origCity)
            ->setOrigState($origState)
            ->setOrigCountry($origCountry)
            ->setDestZip($destZip)
            ->setDestCity($destCity)
            ->setDestState($destState)
            ->setDestCountry($destCountry)
            ->setShipments($shipments)
            ->setAccessorialCodes($accessorialCodes)
            ->setProfileCode($profileCode)
            ->setClientCode($clientCode)
            ->setSrvToken($srvToken)
            ->setUsrToken($usrToken)
            ->setSCAC($sCAC)
            ->setZoneCode($zoneCode)
            ->setServiceLevelCode($serviceLevelCode)
            ->setRoute($route)
            ->setLCC($lCC);
    }
    /**
     * Get ShipmentDate value
     * @return string
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \StructType\LTLRequest
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get Miles value
     * @return float
     */
    public function getMiles()
    {
        return $this->Miles;
    }
    /**
     * Set Miles value
     * @param float $miles
     * @return \StructType\LTLRequest
     */
    public function setMiles($miles = null)
    {
        $this->Miles = $miles;
        return $this;
    }
    /**
     * Get IsBatch value
     * @return bool
     */
    public function getIsBatch()
    {
        return $this->IsBatch;
    }
    /**
     * Set IsBatch value
     * @param bool $isBatch
     * @return \StructType\LTLRequest
     */
    public function setIsBatch($isBatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBatch) && !is_bool($isBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBatch)), __LINE__);
        }
        $this->IsBatch = $isBatch;
        return $this;
    }
    /**
     * Get TotalLFT value
     * @return float
     */
    public function getTotalLFT()
    {
        return $this->TotalLFT;
    }
    /**
     * Set TotalLFT value
     * @param float $totalLFT
     * @return \StructType\LTLRequest
     */
    public function setTotalLFT($totalLFT = null)
    {
        $this->TotalLFT = $totalLFT;
        return $this;
    }
    /**
     * Get OrigZip value
     * @return string|null
     */
    public function getOrigZip()
    {
        return $this->OrigZip;
    }
    /**
     * Set OrigZip value
     * @param string $origZip
     * @return \StructType\LTLRequest
     */
    public function setOrigZip($origZip = null)
    {
        // validation for constraint: string
        if (!is_null($origZip) && !is_string($origZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origZip)), __LINE__);
        }
        $this->OrigZip = $origZip;
        return $this;
    }
    /**
     * Get OrigCity value
     * @return string|null
     */
    public function getOrigCity()
    {
        return $this->OrigCity;
    }
    /**
     * Set OrigCity value
     * @param string $origCity
     * @return \StructType\LTLRequest
     */
    public function setOrigCity($origCity = null)
    {
        // validation for constraint: string
        if (!is_null($origCity) && !is_string($origCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origCity)), __LINE__);
        }
        $this->OrigCity = $origCity;
        return $this;
    }
    /**
     * Get OrigState value
     * @return string|null
     */
    public function getOrigState()
    {
        return $this->OrigState;
    }
    /**
     * Set OrigState value
     * @param string $origState
     * @return \StructType\LTLRequest
     */
    public function setOrigState($origState = null)
    {
        // validation for constraint: string
        if (!is_null($origState) && !is_string($origState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origState)), __LINE__);
        }
        $this->OrigState = $origState;
        return $this;
    }
    /**
     * Get OrigCountry value
     * @return string|null
     */
    public function getOrigCountry()
    {
        return $this->OrigCountry;
    }
    /**
     * Set OrigCountry value
     * @param string $origCountry
     * @return \StructType\LTLRequest
     */
    public function setOrigCountry($origCountry = null)
    {
        // validation for constraint: string
        if (!is_null($origCountry) && !is_string($origCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origCountry)), __LINE__);
        }
        $this->OrigCountry = $origCountry;
        return $this;
    }
    /**
     * Get DestZip value
     * @return string|null
     */
    public function getDestZip()
    {
        return $this->DestZip;
    }
    /**
     * Set DestZip value
     * @param string $destZip
     * @return \StructType\LTLRequest
     */
    public function setDestZip($destZip = null)
    {
        // validation for constraint: string
        if (!is_null($destZip) && !is_string($destZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destZip)), __LINE__);
        }
        $this->DestZip = $destZip;
        return $this;
    }
    /**
     * Get DestCity value
     * @return string|null
     */
    public function getDestCity()
    {
        return $this->DestCity;
    }
    /**
     * Set DestCity value
     * @param string $destCity
     * @return \StructType\LTLRequest
     */
    public function setDestCity($destCity = null)
    {
        // validation for constraint: string
        if (!is_null($destCity) && !is_string($destCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destCity)), __LINE__);
        }
        $this->DestCity = $destCity;
        return $this;
    }
    /**
     * Get DestState value
     * @return string|null
     */
    public function getDestState()
    {
        return $this->DestState;
    }
    /**
     * Set DestState value
     * @param string $destState
     * @return \StructType\LTLRequest
     */
    public function setDestState($destState = null)
    {
        // validation for constraint: string
        if (!is_null($destState) && !is_string($destState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destState)), __LINE__);
        }
        $this->DestState = $destState;
        return $this;
    }
    /**
     * Get DestCountry value
     * @return string|null
     */
    public function getDestCountry()
    {
        return $this->DestCountry;
    }
    /**
     * Set DestCountry value
     * @param string $destCountry
     * @return \StructType\LTLRequest
     */
    public function setDestCountry($destCountry = null)
    {
        // validation for constraint: string
        if (!is_null($destCountry) && !is_string($destCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destCountry)), __LINE__);
        }
        $this->DestCountry = $destCountry;
        return $this;
    }
    /**
     * Get Shipments value
     * @return \ArrayType\ArrayOfShipment|null
     */
    public function getShipments()
    {
        return $this->Shipments;
    }
    /**
     * Set Shipments value
     * @param \ArrayType\ArrayOfShipment $shipments
     * @return \StructType\LTLRequest
     */
    public function setShipments(\ArrayType\ArrayOfShipment $shipments = null)
    {
        $this->Shipments = $shipments;
        return $this;
    }
    /**
     * Get AccessorialCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAccessorialCodes()
    {
        return $this->AccessorialCodes;
    }
    /**
     * Set AccessorialCodes value
     * @param \ArrayType\ArrayOfString $accessorialCodes
     * @return \StructType\LTLRequest
     */
    public function setAccessorialCodes(\ArrayType\ArrayOfString $accessorialCodes = null)
    {
        $this->AccessorialCodes = $accessorialCodes;
        return $this;
    }
    /**
     * Get ProfileCode value
     * @return string|null
     */
    public function getProfileCode()
    {
        return $this->ProfileCode;
    }
    /**
     * Set ProfileCode value
     * @param string $profileCode
     * @return \StructType\LTLRequest
     */
    public function setProfileCode($profileCode = null)
    {
        // validation for constraint: string
        if (!is_null($profileCode) && !is_string($profileCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileCode)), __LINE__);
        }
        $this->ProfileCode = $profileCode;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\LTLRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get SrvToken value
     * @return string|null
     */
    public function getSrvToken()
    {
        return $this->SrvToken;
    }
    /**
     * Set SrvToken value
     * @param string $srvToken
     * @return \StructType\LTLRequest
     */
    public function setSrvToken($srvToken = null)
    {
        // validation for constraint: string
        if (!is_null($srvToken) && !is_string($srvToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srvToken)), __LINE__);
        }
        $this->SrvToken = $srvToken;
        return $this;
    }
    /**
     * Get UsrToken value
     * @return string|null
     */
    public function getUsrToken()
    {
        return $this->UsrToken;
    }
    /**
     * Set UsrToken value
     * @param string $usrToken
     * @return \StructType\LTLRequest
     */
    public function setUsrToken($usrToken = null)
    {
        // validation for constraint: string
        if (!is_null($usrToken) && !is_string($usrToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usrToken)), __LINE__);
        }
        $this->UsrToken = $usrToken;
        return $this;
    }
    /**
     * Get SCAC value
     * @return string|null
     */
    public function getSCAC()
    {
        return $this->SCAC;
    }
    /**
     * Set SCAC value
     * @param string $sCAC
     * @return \StructType\LTLRequest
     */
    public function setSCAC($sCAC = null)
    {
        // validation for constraint: string
        if (!is_null($sCAC) && !is_string($sCAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCAC)), __LINE__);
        }
        $this->SCAC = $sCAC;
        return $this;
    }
    /**
     * Get ZoneCode value
     * @return string|null
     */
    public function getZoneCode()
    {
        return $this->ZoneCode;
    }
    /**
     * Set ZoneCode value
     * @param string $zoneCode
     * @return \StructType\LTLRequest
     */
    public function setZoneCode($zoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($zoneCode) && !is_string($zoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zoneCode)), __LINE__);
        }
        $this->ZoneCode = $zoneCode;
        return $this;
    }
    /**
     * Get ServiceLevelCode value
     * @return string|null
     */
    public function getServiceLevelCode()
    {
        return $this->ServiceLevelCode;
    }
    /**
     * Set ServiceLevelCode value
     * @param string $serviceLevelCode
     * @return \StructType\LTLRequest
     */
    public function setServiceLevelCode($serviceLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLevelCode) && !is_string($serviceLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLevelCode)), __LINE__);
        }
        $this->ServiceLevelCode = $serviceLevelCode;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @param string $route
     * @return \StructType\LTLRequest
     */
    public function setRoute($route = null)
    {
        // validation for constraint: string
        if (!is_null($route) && !is_string($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($route)), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get LCC value
     * @return string|null
     */
    public function getLCC()
    {
        return $this->LCC;
    }
    /**
     * Set LCC value
     * @param string $lCC
     * @return \StructType\LTLRequest
     */
    public function setLCC($lCC = null)
    {
        // validation for constraint: string
        if (!is_null($lCC) && !is_string($lCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lCC)), __LINE__);
        }
        $this->LCC = $lCC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LTLRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
