<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTLRatingResponse2 StructType
 * @subpackage Structs
 */
class LTLRatingResponse2 extends AbstractStructBase
{
    /**
     * The GrossCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossCharge;
    /**
     * The NetCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetCharge;
    /**
     * The FuelSurcharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelSurcharge;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The GSTCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GSTCost;
    /**
     * The ProvidenceCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProvidenceCost;
    /**
     * The TotalShipmentCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalShipmentCost;
    /**
     * The TransitDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransitDays;
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DiscountRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountRate;
    /**
     * The IsCarrierAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCarrierAvailable;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The SCAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SCAC;
    /**
     * The GSTDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GSTDescription;
    /**
     * The ProvidenceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProvidenceDescription;
    /**
     * The OrigTerminalPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrigTerminalPhone;
    /**
     * The DestTerminalPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestTerminalPhone;
    /**
     * The AccessorialCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLaneAccessorialRates
     */
    public $AccessorialCharges;
    /**
     * Constructor method for LTLRatingResponse2
     * @uses LTLRatingResponse2::setGrossCharge()
     * @uses LTLRatingResponse2::setNetCharge()
     * @uses LTLRatingResponse2::setFuelSurcharge()
     * @uses LTLRatingResponse2::setDiscount()
     * @uses LTLRatingResponse2::setGSTCost()
     * @uses LTLRatingResponse2::setProvidenceCost()
     * @uses LTLRatingResponse2::setTotalShipmentCost()
     * @uses LTLRatingResponse2::setTransitDays()
     * @uses LTLRatingResponse2::setDeliveryDate()
     * @uses LTLRatingResponse2::setDiscountRate()
     * @uses LTLRatingResponse2::setIsCarrierAvailable()
     * @uses LTLRatingResponse2::setErrorMessage()
     * @uses LTLRatingResponse2::setCarrierName()
     * @uses LTLRatingResponse2::setSCAC()
     * @uses LTLRatingResponse2::setGSTDescription()
     * @uses LTLRatingResponse2::setProvidenceDescription()
     * @uses LTLRatingResponse2::setOrigTerminalPhone()
     * @uses LTLRatingResponse2::setDestTerminalPhone()
     * @uses LTLRatingResponse2::setAccessorialCharges()
     * @param float $grossCharge
     * @param float $netCharge
     * @param float $fuelSurcharge
     * @param float $discount
     * @param float $gSTCost
     * @param float $providenceCost
     * @param float $totalShipmentCost
     * @param int $transitDays
     * @param string $deliveryDate
     * @param float $discountRate
     * @param bool $isCarrierAvailable
     * @param string $errorMessage
     * @param string $carrierName
     * @param string $sCAC
     * @param string $gSTDescription
     * @param string $providenceDescription
     * @param string $origTerminalPhone
     * @param string $destTerminalPhone
     * @param \ArrayType\ArrayOfLaneAccessorialRates $accessorialCharges
     */
    public function __construct($grossCharge = null, $netCharge = null, $fuelSurcharge = null, $discount = null, $gSTCost = null, $providenceCost = null, $totalShipmentCost = null, $transitDays = null, $deliveryDate = null, $discountRate = null, $isCarrierAvailable = null, $errorMessage = null, $carrierName = null, $sCAC = null, $gSTDescription = null, $providenceDescription = null, $origTerminalPhone = null, $destTerminalPhone = null, \ArrayType\ArrayOfLaneAccessorialRates $accessorialCharges = null)
    {
        $this
            ->setGrossCharge($grossCharge)
            ->setNetCharge($netCharge)
            ->setFuelSurcharge($fuelSurcharge)
            ->setDiscount($discount)
            ->setGSTCost($gSTCost)
            ->setProvidenceCost($providenceCost)
            ->setTotalShipmentCost($totalShipmentCost)
            ->setTransitDays($transitDays)
            ->setDeliveryDate($deliveryDate)
            ->setDiscountRate($discountRate)
            ->setIsCarrierAvailable($isCarrierAvailable)
            ->setErrorMessage($errorMessage)
            ->setCarrierName($carrierName)
            ->setSCAC($sCAC)
            ->setGSTDescription($gSTDescription)
            ->setProvidenceDescription($providenceDescription)
            ->setOrigTerminalPhone($origTerminalPhone)
            ->setDestTerminalPhone($destTerminalPhone)
            ->setAccessorialCharges($accessorialCharges);
    }
    /**
     * Get GrossCharge value
     * @return float
     */
    public function getGrossCharge()
    {
        return $this->GrossCharge;
    }
    /**
     * Set GrossCharge value
     * @param float $grossCharge
     * @return \StructType\LTLRatingResponse2
     */
    public function setGrossCharge($grossCharge = null)
    {
        $this->GrossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get NetCharge value
     * @return float
     */
    public function getNetCharge()
    {
        return $this->NetCharge;
    }
    /**
     * Set NetCharge value
     * @param float $netCharge
     * @return \StructType\LTLRatingResponse2
     */
    public function setNetCharge($netCharge = null)
    {
        $this->NetCharge = $netCharge;
        return $this;
    }
    /**
     * Get FuelSurcharge value
     * @return float
     */
    public function getFuelSurcharge()
    {
        return $this->FuelSurcharge;
    }
    /**
     * Set FuelSurcharge value
     * @param float $fuelSurcharge
     * @return \StructType\LTLRatingResponse2
     */
    public function setFuelSurcharge($fuelSurcharge = null)
    {
        $this->FuelSurcharge = $fuelSurcharge;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\LTLRatingResponse2
     */
    public function setDiscount($discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get GSTCost value
     * @return float
     */
    public function getGSTCost()
    {
        return $this->GSTCost;
    }
    /**
     * Set GSTCost value
     * @param float $gSTCost
     * @return \StructType\LTLRatingResponse2
     */
    public function setGSTCost($gSTCost = null)
    {
        $this->GSTCost = $gSTCost;
        return $this;
    }
    /**
     * Get ProvidenceCost value
     * @return float
     */
    public function getProvidenceCost()
    {
        return $this->ProvidenceCost;
    }
    /**
     * Set ProvidenceCost value
     * @param float $providenceCost
     * @return \StructType\LTLRatingResponse2
     */
    public function setProvidenceCost($providenceCost = null)
    {
        $this->ProvidenceCost = $providenceCost;
        return $this;
    }
    /**
     * Get TotalShipmentCost value
     * @return float
     */
    public function getTotalShipmentCost()
    {
        return $this->TotalShipmentCost;
    }
    /**
     * Set TotalShipmentCost value
     * @param float $totalShipmentCost
     * @return \StructType\LTLRatingResponse2
     */
    public function setTotalShipmentCost($totalShipmentCost = null)
    {
        $this->TotalShipmentCost = $totalShipmentCost;
        return $this;
    }
    /**
     * Get TransitDays value
     * @return int
     */
    public function getTransitDays()
    {
        return $this->TransitDays;
    }
    /**
     * Set TransitDays value
     * @param int $transitDays
     * @return \StructType\LTLRatingResponse2
     */
    public function setTransitDays($transitDays = null)
    {
        // validation for constraint: int
        if (!is_null($transitDays) && !is_numeric($transitDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transitDays)), __LINE__);
        }
        $this->TransitDays = $transitDays;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\LTLRatingResponse2
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DiscountRate value
     * @return float
     */
    public function getDiscountRate()
    {
        return $this->DiscountRate;
    }
    /**
     * Set DiscountRate value
     * @param float $discountRate
     * @return \StructType\LTLRatingResponse2
     */
    public function setDiscountRate($discountRate = null)
    {
        $this->DiscountRate = $discountRate;
        return $this;
    }
    /**
     * Get IsCarrierAvailable value
     * @return bool
     */
    public function getIsCarrierAvailable()
    {
        return $this->IsCarrierAvailable;
    }
    /**
     * Set IsCarrierAvailable value
     * @param bool $isCarrierAvailable
     * @return \StructType\LTLRatingResponse2
     */
    public function setIsCarrierAvailable($isCarrierAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCarrierAvailable) && !is_bool($isCarrierAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCarrierAvailable)), __LINE__);
        }
        $this->IsCarrierAvailable = $isCarrierAvailable;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\LTLRatingResponse2
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\LTLRatingResponse2
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get SCAC value
     * @return string|null
     */
    public function getSCAC()
    {
        return $this->SCAC;
    }
    /**
     * Set SCAC value
     * @param string $sCAC
     * @return \StructType\LTLRatingResponse2
     */
    public function setSCAC($sCAC = null)
    {
        // validation for constraint: string
        if (!is_null($sCAC) && !is_string($sCAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sCAC)), __LINE__);
        }
        $this->SCAC = $sCAC;
        return $this;
    }
    /**
     * Get GSTDescription value
     * @return string|null
     */
    public function getGSTDescription()
    {
        return $this->GSTDescription;
    }
    /**
     * Set GSTDescription value
     * @param string $gSTDescription
     * @return \StructType\LTLRatingResponse2
     */
    public function setGSTDescription($gSTDescription = null)
    {
        // validation for constraint: string
        if (!is_null($gSTDescription) && !is_string($gSTDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gSTDescription)), __LINE__);
        }
        $this->GSTDescription = $gSTDescription;
        return $this;
    }
    /**
     * Get ProvidenceDescription value
     * @return string|null
     */
    public function getProvidenceDescription()
    {
        return $this->ProvidenceDescription;
    }
    /**
     * Set ProvidenceDescription value
     * @param string $providenceDescription
     * @return \StructType\LTLRatingResponse2
     */
    public function setProvidenceDescription($providenceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($providenceDescription) && !is_string($providenceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providenceDescription)), __LINE__);
        }
        $this->ProvidenceDescription = $providenceDescription;
        return $this;
    }
    /**
     * Get OrigTerminalPhone value
     * @return string|null
     */
    public function getOrigTerminalPhone()
    {
        return $this->OrigTerminalPhone;
    }
    /**
     * Set OrigTerminalPhone value
     * @param string $origTerminalPhone
     * @return \StructType\LTLRatingResponse2
     */
    public function setOrigTerminalPhone($origTerminalPhone = null)
    {
        // validation for constraint: string
        if (!is_null($origTerminalPhone) && !is_string($origTerminalPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origTerminalPhone)), __LINE__);
        }
        $this->OrigTerminalPhone = $origTerminalPhone;
        return $this;
    }
    /**
     * Get DestTerminalPhone value
     * @return string|null
     */
    public function getDestTerminalPhone()
    {
        return $this->DestTerminalPhone;
    }
    /**
     * Set DestTerminalPhone value
     * @param string $destTerminalPhone
     * @return \StructType\LTLRatingResponse2
     */
    public function setDestTerminalPhone($destTerminalPhone = null)
    {
        // validation for constraint: string
        if (!is_null($destTerminalPhone) && !is_string($destTerminalPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destTerminalPhone)), __LINE__);
        }
        $this->DestTerminalPhone = $destTerminalPhone;
        return $this;
    }
    /**
     * Get AccessorialCharges value
     * @return \ArrayType\ArrayOfLaneAccessorialRates|null
     */
    public function getAccessorialCharges()
    {
        return $this->AccessorialCharges;
    }
    /**
     * Set AccessorialCharges value
     * @param \ArrayType\ArrayOfLaneAccessorialRates $accessorialCharges
     * @return \StructType\LTLRatingResponse2
     */
    public function setAccessorialCharges(\ArrayType\ArrayOfLaneAccessorialRates $accessorialCharges = null)
    {
        $this->AccessorialCharges = $accessorialCharges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LTLRatingResponse2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
