<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The Units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Units;
    /**
     * The CubicFeet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CubicFeet;
    /**
     * The HazMat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HazMat;
    /**
     * The Class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Class;
    /**
     * The NMFC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NMFC;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setWeight()
     * @uses Shipment::setUnits()
     * @uses Shipment::setCubicFeet()
     * @uses Shipment::setHazMat()
     * @uses Shipment::setClass()
     * @uses Shipment::setNMFC()
     * @param float $weight
     * @param int $units
     * @param float $cubicFeet
     * @param bool $hazMat
     * @param string $class
     * @param string $nMFC
     */
    public function __construct($weight = null, $units = null, $cubicFeet = null, $hazMat = null, $class = null, $nMFC = null)
    {
        $this
            ->setWeight($weight)
            ->setUnits($units)
            ->setCubicFeet($cubicFeet)
            ->setHazMat($hazMat)
            ->setClass($class)
            ->setNMFC($nMFC);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Shipment
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Units value
     * @return int
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param int $units
     * @return \StructType\Shipment
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !is_numeric($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get CubicFeet value
     * @return float
     */
    public function getCubicFeet()
    {
        return $this->CubicFeet;
    }
    /**
     * Set CubicFeet value
     * @param float $cubicFeet
     * @return \StructType\Shipment
     */
    public function setCubicFeet($cubicFeet = null)
    {
        $this->CubicFeet = $cubicFeet;
        return $this;
    }
    /**
     * Get HazMat value
     * @return bool
     */
    public function getHazMat()
    {
        return $this->HazMat;
    }
    /**
     * Set HazMat value
     * @param bool $hazMat
     * @return \StructType\Shipment
     */
    public function setHazMat($hazMat = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazMat) && !is_bool($hazMat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hazMat)), __LINE__);
        }
        $this->HazMat = $hazMat;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\Shipment
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get NMFC value
     * @return string|null
     */
    public function getNMFC()
    {
        return $this->NMFC;
    }
    /**
     * Set NMFC value
     * @param string $nMFC
     * @return \StructType\Shipment
     */
    public function setNMFC($nMFC = null)
    {
        // validation for constraint: string
        if (!is_null($nMFC) && !is_string($nMFC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nMFC)), __LINE__);
        }
        $this->NMFC = $nMFC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
