<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileDetail StructType
 * @subpackage Structs
 */
class ProfileDetail extends AbstractStructBase
{
    /**
     * The ProfileCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileCode;
    /**
     * The ProfileDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileDescription;
    /**
     * Constructor method for ProfileDetail
     * @uses ProfileDetail::setProfileCode()
     * @uses ProfileDetail::setProfileDescription()
     * @param string $profileCode
     * @param string $profileDescription
     */
    public function __construct($profileCode = null, $profileDescription = null)
    {
        $this
            ->setProfileCode($profileCode)
            ->setProfileDescription($profileDescription);
    }
    /**
     * Get ProfileCode value
     * @return string|null
     */
    public function getProfileCode()
    {
        return $this->ProfileCode;
    }
    /**
     * Set ProfileCode value
     * @param string $profileCode
     * @return \StructType\ProfileDetail
     */
    public function setProfileCode($profileCode = null)
    {
        // validation for constraint: string
        if (!is_null($profileCode) && !is_string($profileCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileCode)), __LINE__);
        }
        $this->ProfileCode = $profileCode;
        return $this;
    }
    /**
     * Get ProfileDescription value
     * @return string|null
     */
    public function getProfileDescription()
    {
        return $this->ProfileDescription;
    }
    /**
     * Set ProfileDescription value
     * @param string $profileDescription
     * @return \StructType\ProfileDetail
     */
    public function setProfileDescription($profileDescription = null)
    {
        // validation for constraint: string
        if (!is_null($profileDescription) && !is_string($profileDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileDescription)), __LINE__);
        }
        $this->ProfileDescription = $profileDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
