<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProfileDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfProfileDetail extends AbstractStructArrayBase
{
    /**
     * The ProfileDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileDetail[]
     */
    public $ProfileDetail;
    /**
     * Constructor method for ArrayOfProfileDetail
     * @uses ArrayOfProfileDetail::setProfileDetail()
     * @param \StructType\ProfileDetail[] $profileDetail
     */
    public function __construct(array $profileDetail = array())
    {
        $this
            ->setProfileDetail($profileDetail);
    }
    /**
     * Get ProfileDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileDetail[]|null
     */
    public function getProfileDetail()
    {
        return isset($this->ProfileDetail) ? $this->ProfileDetail : null;
    }
    /**
     * Set ProfileDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileDetail[] $profileDetail
     * @return \ArrayType\ArrayOfProfileDetail
     */
    public function setProfileDetail(array $profileDetail = array())
    {
        foreach ($profileDetail as $arrayOfProfileDetailProfileDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfProfileDetailProfileDetailItem instanceof \StructType\ProfileDetail) {
                throw new \InvalidArgumentException(sprintf('The ProfileDetail property can only contain items of \StructType\ProfileDetail, "%s" given', is_object($arrayOfProfileDetailProfileDetailItem) ? get_class($arrayOfProfileDetailProfileDetailItem) : gettype($arrayOfProfileDetailProfileDetailItem)), __LINE__);
            }
        }
        if (is_null($profileDetail) || (is_array($profileDetail) && empty($profileDetail))) {
            unset($this->ProfileDetail);
        } else {
            $this->ProfileDetail = $profileDetail;
        }
        return $this;
    }
    /**
     * Add item to ProfileDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileDetail $item
     * @return \ArrayType\ArrayOfProfileDetail
     */
    public function addToProfileDetail(\StructType\ProfileDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileDetail) {
            throw new \InvalidArgumentException(sprintf('The ProfileDetail property can only contain items of \StructType\ProfileDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProfileDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProfileDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProfileDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProfileDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProfileDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProfileDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProfileDetail
     */
    public function getAttributeName()
    {
        return 'ProfileDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProfileDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
