<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ProductSupplier ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ProductSupplier extends AbstractStructArrayBase
{
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ProductSupplier[]
     */
    public $Supplier;
    /**
     * Constructor method for ArrayOfJP_ProductSupplier
     * @uses ArrayOfJP_ProductSupplier::setSupplier()
     * @param \StructType\JP_ProductSupplier[] $supplier
     */
    public function __construct(array $supplier = array())
    {
        $this
            ->setSupplier($supplier);
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_ProductSupplier[]|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ProductSupplier[] $supplier
     * @return \ArrayType\ArrayOfJP_ProductSupplier
     */
    public function setSupplier(array $supplier = array())
    {
        foreach ($supplier as $arrayOfJP_ProductSupplierSupplierItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ProductSupplierSupplierItem instanceof \StructType\JP_ProductSupplier) {
                throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of \StructType\JP_ProductSupplier, "%s" given', is_object($arrayOfJP_ProductSupplierSupplierItem) ? get_class($arrayOfJP_ProductSupplierSupplierItem) : gettype($arrayOfJP_ProductSupplierSupplierItem)), __LINE__);
            }
        }
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ProductSupplier $item
     * @return \ArrayType\ArrayOfJP_ProductSupplier
     */
    public function addToSupplier(\StructType\JP_ProductSupplier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ProductSupplier) {
            throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of \StructType\JP_ProductSupplier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supplier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ProductSupplier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ProductSupplier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ProductSupplier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ProductSupplier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ProductSupplier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Supplier
     */
    public function getAttributeName()
    {
        return 'Supplier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ProductSupplier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
