<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_AgencyData ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_AgencyData extends AbstractStructArrayBase
{
    /**
     * The AgencyData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_AgencyData[]
     */
    public $AgencyData;
    /**
     * Constructor method for ArrayOfJP_AgencyData
     * @uses ArrayOfJP_AgencyData::setAgencyData()
     * @param \StructType\JP_AgencyData[] $agencyData
     */
    public function __construct(array $agencyData = array())
    {
        $this
            ->setAgencyData($agencyData);
    }
    /**
     * Get AgencyData value
     * @return \StructType\JP_AgencyData[]|null
     */
    public function getAgencyData()
    {
        return $this->AgencyData;
    }
    /**
     * Set AgencyData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AgencyData[] $agencyData
     * @return \ArrayType\ArrayOfJP_AgencyData
     */
    public function setAgencyData(array $agencyData = array())
    {
        foreach ($agencyData as $arrayOfJP_AgencyDataAgencyDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_AgencyDataAgencyDataItem instanceof \StructType\JP_AgencyData) {
                throw new \InvalidArgumentException(sprintf('The AgencyData property can only contain items of \StructType\JP_AgencyData, "%s" given', is_object($arrayOfJP_AgencyDataAgencyDataItem) ? get_class($arrayOfJP_AgencyDataAgencyDataItem) : gettype($arrayOfJP_AgencyDataAgencyDataItem)), __LINE__);
            }
        }
        $this->AgencyData = $agencyData;
        return $this;
    }
    /**
     * Add item to AgencyData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AgencyData $item
     * @return \ArrayType\ArrayOfJP_AgencyData
     */
    public function addToAgencyData(\StructType\JP_AgencyData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_AgencyData) {
            throw new \InvalidArgumentException(sprintf('The AgencyData property can only contain items of \StructType\JP_AgencyData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AgencyData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_AgencyData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_AgencyData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_AgencyData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_AgencyData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_AgencyData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AgencyData
     */
    public function getAttributeName()
    {
        return 'AgencyData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_AgencyData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
