<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_WarningDistribution StructType
 * @subpackage Structs
 */
class JP_WarningDistribution extends AbstractStructBase
{
    /**
     * The Adults
     * @var int
     */
    public $Adults;
    /**
     * The Children
     * @var int
     */
    public $Children;
    /**
     * Constructor method for JP_WarningDistribution
     * @uses JP_WarningDistribution::setAdults()
     * @uses JP_WarningDistribution::setChildren()
     * @param int $adults
     * @param int $children
     */
    public function __construct($adults = null, $children = null)
    {
        $this
            ->setAdults($adults)
            ->setChildren($children);
    }
    /**
     * Get Adults value
     * @return int|null
     */
    public function getAdults()
    {
        return $this->Adults;
    }
    /**
     * Set Adults value
     * @param int $adults
     * @return \StructType\JP_WarningDistribution
     */
    public function setAdults($adults = null)
    {
        // validation for constraint: int
        if (!is_null($adults) && !is_numeric($adults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adults)), __LINE__);
        }
        $this->Adults = $adults;
        return $this;
    }
    /**
     * Get Children value
     * @return int|null
     */
    public function getChildren()
    {
        return $this->Children;
    }
    /**
     * Set Children value
     * @param int $children
     * @return \StructType\JP_WarningDistribution
     */
    public function setChildren($children = null)
    {
        // validation for constraint: int
        if (!is_null($children) && !is_numeric($children)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($children)), __LINE__);
        }
        $this->Children = $children;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_WarningDistribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
