<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SupplierListRequest StructType
 * @subpackage Structs
 */
class JP_SupplierListRequest extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProductType;
    /**
     * Constructor method for JP_SupplierListRequest
     * @uses JP_SupplierListRequest::setProductType()
     * @param string $productType
     */
    public function __construct($productType = null)
    {
        $this
            ->setProductType($productType);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_SupplierListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SupplierListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
