<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceResult StructType
 * @subpackage Structs
 */
class JP_ServiceResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The DestinationZone
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The ServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceInfo
     */
    public $ServiceInfo;
    /**
     * The ServiceOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $ServiceOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_ServiceResult
     * @uses JP_ServiceResult::setStart()
     * @uses JP_ServiceResult::setEnd()
     * @uses JP_ServiceResult::setDestinationZone()
     * @uses JP_ServiceResult::setStatus()
     * @uses JP_ServiceResult::setServiceInfo()
     * @uses JP_ServiceResult::setServiceOptions()
     * @uses JP_ServiceResult::setCode()
     * @param string $start
     * @param string $end
     * @param int $destinationZone
     * @param string $status
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @param string $code
     */
    public function __construct($start = null, $end = null, $destinationZone = null, $status = null, \StructType\JP_ServiceInfo $serviceInfo = null, \ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setDestinationZone($destinationZone)
            ->setStatus($status)
            ->setServiceInfo($serviceInfo)
            ->setServiceOptions($serviceOptions)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_ServiceResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_ServiceResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_ServiceResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !is_numeric($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_ServiceResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ServiceInfo value
     * @return \StructType\JP_ServiceInfo|null
     */
    public function getServiceInfo()
    {
        return $this->ServiceInfo;
    }
    /**
     * Set ServiceInfo value
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @return \StructType\JP_ServiceResult
     */
    public function setServiceInfo(\StructType\JP_ServiceInfo $serviceInfo = null)
    {
        $this->ServiceInfo = $serviceInfo;
        return $this;
    }
    /**
     * Get ServiceOptions value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getServiceOptions()
    {
        return $this->ServiceOptions;
    }
    /**
     * Set ServiceOptions value
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @return \StructType\JP_ServiceResult
     */
    public function setServiceOptions(\ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null)
    {
        $this->ServiceOptions = $serviceOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
