<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarBookingRulesOption StructType
 * @subpackage Structs
 */
class JP_RentacarBookingRulesOption extends AbstractStructBase
{
    /**
     * The RentacarInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The RentcarRequiredFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentcarRequiredFields
     */
    public $RentcarRequiredFields;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PriceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarPriceInformation
     */
    public $PriceInformation;
    /**
     * The OptionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarOptionalElements
     */
    public $OptionalElements;
    /**
     * The PickUpCode
     * @var string
     */
    public $PickUpCode;
    /**
     * The DropOffCode
     * @var string
     */
    public $DropOffCode;
    /**
     * The AcrissCode
     * @var string
     */
    public $AcrissCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The PaymentOffice
     * @var bool
     */
    public $PaymentOffice;
    /**
     * Constructor method for JP_RentacarBookingRulesOption
     * @uses JP_RentacarBookingRulesOption::setRentacarInfo()
     * @uses JP_RentacarBookingRulesOption::setBookingCode()
     * @uses JP_RentacarBookingRulesOption::setRentcarRequiredFields()
     * @uses JP_RentacarBookingRulesOption::setCancellationPolicy()
     * @uses JP_RentacarBookingRulesOption::setCancellationPolicyCost()
     * @uses JP_RentacarBookingRulesOption::setPriceInformation()
     * @uses JP_RentacarBookingRulesOption::setOptionalElements()
     * @uses JP_RentacarBookingRulesOption::setPickUpCode()
     * @uses JP_RentacarBookingRulesOption::setDropOffCode()
     * @uses JP_RentacarBookingRulesOption::setAcrissCode()
     * @uses JP_RentacarBookingRulesOption::setRatePlanCode()
     * @uses JP_RentacarBookingRulesOption::setStatus()
     * @uses JP_RentacarBookingRulesOption::setPaymentOffice()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_RentcarRequiredFields $rentcarRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \StructType\JP_RentacarPriceInformation $priceInformation
     * @param \StructType\JP_RentacarOptionalElements $optionalElements
     * @param string $pickUpCode
     * @param string $dropOffCode
     * @param string $acrissCode
     * @param string $ratePlanCode
     * @param string $status
     * @param bool $paymentOffice
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_RentcarRequiredFields $rentcarRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \StructType\JP_RentacarPriceInformation $priceInformation = null, \StructType\JP_RentacarOptionalElements $optionalElements = null, $pickUpCode = null, $dropOffCode = null, $acrissCode = null, $ratePlanCode = null, $status = null, $paymentOffice = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setBookingCode($bookingCode)
            ->setRentcarRequiredFields($rentcarRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPriceInformation($priceInformation)
            ->setOptionalElements($optionalElements)
            ->setPickUpCode($pickUpCode)
            ->setDropOffCode($dropOffCode)
            ->setAcrissCode($acrissCode)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setPaymentOffice($paymentOffice);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get RentcarRequiredFields value
     * @return \StructType\JP_RentcarRequiredFields|null
     */
    public function getRentcarRequiredFields()
    {
        return $this->RentcarRequiredFields;
    }
    /**
     * Set RentcarRequiredFields value
     * @param \StructType\JP_RentcarRequiredFields $rentcarRequiredFields
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setRentcarRequiredFields(\StructType\JP_RentcarRequiredFields $rentcarRequiredFields = null)
    {
        $this->RentcarRequiredFields = $rentcarRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_RentacarPriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_RentacarPriceInformation $priceInformation
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setPriceInformation(\StructType\JP_RentacarPriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_RentacarOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_RentacarOptionalElements $optionalElements
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setOptionalElements(\StructType\JP_RentacarOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get PickUpCode value
     * @return string|null
     */
    public function getPickUpCode()
    {
        return $this->PickUpCode;
    }
    /**
     * Set PickUpCode value
     * @param string $pickUpCode
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setPickUpCode($pickUpCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpCode) && !is_string($pickUpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickUpCode)), __LINE__);
        }
        $this->PickUpCode = $pickUpCode;
        return $this;
    }
    /**
     * Get DropOffCode value
     * @return string|null
     */
    public function getDropOffCode()
    {
        return $this->DropOffCode;
    }
    /**
     * Set DropOffCode value
     * @param string $dropOffCode
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setDropOffCode($dropOffCode = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffCode) && !is_string($dropOffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dropOffCode)), __LINE__);
        }
        $this->DropOffCode = $dropOffCode;
        return $this;
    }
    /**
     * Get AcrissCode value
     * @return string|null
     */
    public function getAcrissCode()
    {
        return $this->AcrissCode;
    }
    /**
     * Set AcrissCode value
     * @param string $acrissCode
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setAcrissCode($acrissCode = null)
    {
        // validation for constraint: string
        if (!is_null($acrissCode) && !is_string($acrissCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acrissCode)), __LINE__);
        }
        $this->AcrissCode = $acrissCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaymentOffice value
     * @return bool|null
     */
    public function getPaymentOffice()
    {
        return $this->PaymentOffice;
    }
    /**
     * Set PaymentOffice value
     * @param bool $paymentOffice
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public function setPaymentOffice($paymentOffice = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentOffice) && !is_bool($paymentOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentOffice)), __LINE__);
        }
        $this->PaymentOffice = $paymentOffice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarBookingRulesOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
