<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PriceFrom StructType
 * @subpackage Structs
 */
class JP_PriceFrom extends AbstractStructBase
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $From;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_PriceFrom
     * @uses JP_PriceFrom::setFrom()
     * @uses JP_PriceFrom::setStart()
     * @uses JP_PriceFrom::setEnd()
     * @uses JP_PriceFrom::setCurrency()
     * @param float $from
     * @param string $start
     * @param string $end
     * @param string $currency
     */
    public function __construct($from = null, $start = null, $end = null, $currency = null)
    {
        $this
            ->setFrom($from)
            ->setStart($start)
            ->setEnd($end)
            ->setCurrency($currency);
    }
    /**
     * Get From value
     * @return float
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param float $from
     * @return \StructType\JP_PriceFrom
     */
    public function setFrom($from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PriceFrom
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PriceFrom
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_PriceFrom
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PriceFrom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
