<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Origin StructType
 * @subpackage Structs
 */
class JP_Origin extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * Constructor method for JP_Origin
     * @uses JP_Origin::setName()
     * @uses JP_Origin::setCode()
     * @uses JP_Origin::setType()
     * @uses JP_Origin::setRoute()
     * @param string $name
     * @param string $code
     * @param string $type
     * @param string $route
     */
    public function __construct($name = null, $code = null, $type = null, $route = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setType($type)
            ->setRoute($route);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Origin
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Origin
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_Origin
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_Origin
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $route, implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Origin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
