<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingPointsZone StructType
 * @subpackage Structs
 */
class JP_MeetingPointsZone extends AbstractStructBase
{
    /**
     * The MeetingPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPoint[]
     */
    public $MeetingPoint;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for JP_MeetingPointsZone
     * @uses JP_MeetingPointsZone::setMeetingPoint()
     * @uses JP_MeetingPointsZone::setName()
     * @param \StructType\JP_MeetingPoint[] $meetingPoint
     * @param string $name
     */
    public function __construct(array $meetingPoint = array(), $name = null)
    {
        $this
            ->setMeetingPoint($meetingPoint)
            ->setName($name);
    }
    /**
     * Get MeetingPoint value
     * @return \StructType\JP_MeetingPoint[]|null
     */
    public function getMeetingPoint()
    {
        return $this->MeetingPoint;
    }
    /**
     * Set MeetingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MeetingPoint[] $meetingPoint
     * @return \StructType\JP_MeetingPointsZone
     */
    public function setMeetingPoint(array $meetingPoint = array())
    {
        foreach ($meetingPoint as $jP_MeetingPointsZoneMeetingPointItem) {
            // validation for constraint: itemType
            if (!$jP_MeetingPointsZoneMeetingPointItem instanceof \StructType\JP_MeetingPoint) {
                throw new \InvalidArgumentException(sprintf('The MeetingPoint property can only contain items of \StructType\JP_MeetingPoint, "%s" given', is_object($jP_MeetingPointsZoneMeetingPointItem) ? get_class($jP_MeetingPointsZoneMeetingPointItem) : gettype($jP_MeetingPointsZoneMeetingPointItem)), __LINE__);
            }
        }
        $this->MeetingPoint = $meetingPoint;
        return $this;
    }
    /**
     * Add item to MeetingPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MeetingPoint $item
     * @return \StructType\JP_MeetingPointsZone
     */
    public function addToMeetingPoint(\StructType\JP_MeetingPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_MeetingPoint) {
            throw new \InvalidArgumentException(sprintf('The MeetingPoint property can only contain items of \StructType\JP_MeetingPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MeetingPoint[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_MeetingPointsZone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_MeetingPointsZone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
