<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelPortfolio StructType
 * @subpackage Structs
 */
class JP_HotelPortfolio extends AbstractStructBase
{
    /**
     * The Page
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecordsPerPage;
    /**
     * The TotalPages
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The TotalRecords
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalRecords;
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ExtendedHotelInfo[]
     */
    public $Hotel;
    /**
     * Constructor method for JP_HotelPortfolio
     * @uses JP_HotelPortfolio::setPage()
     * @uses JP_HotelPortfolio::setRecordsPerPage()
     * @uses JP_HotelPortfolio::setTotalPages()
     * @uses JP_HotelPortfolio::setTotalRecords()
     * @uses JP_HotelPortfolio::setHotel()
     * @param int $page
     * @param int $recordsPerPage
     * @param int $totalPages
     * @param int $totalRecords
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     */
    public function __construct($page = null, $recordsPerPage = null, $totalPages = null, $totalRecords = null, array $hotel = array())
    {
        $this
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage)
            ->setTotalPages($totalPages)
            ->setTotalRecords($totalRecords)
            ->setHotel($hotel);
    }
    /**
     * Get Page value
     * @return int
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_HotelPortfolio
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_HotelPortfolio
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !is_numeric($recordsPerPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \StructType\JP_HotelPortfolio
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !is_numeric($totalPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_HotelPortfolio
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !is_numeric($totalRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \StructType\JP_ExtendedHotelInfo[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     * @return \StructType\JP_HotelPortfolio
     */
    public function setHotel(array $hotel = array())
    {
        foreach ($hotel as $jP_HotelPortfolioHotelItem) {
            // validation for constraint: itemType
            if (!$jP_HotelPortfolioHotelItem instanceof \StructType\JP_ExtendedHotelInfo) {
                throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\JP_ExtendedHotelInfo, "%s" given', is_object($jP_HotelPortfolioHotelItem) ? get_class($jP_HotelPortfolioHotelItem) : gettype($jP_HotelPortfolioHotelItem)), __LINE__);
            }
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo $item
     * @return \StructType\JP_HotelPortfolio
     */
    public function addToHotel(\StructType\JP_ExtendedHotelInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ExtendedHotelInfo) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\JP_ExtendedHotelInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelPortfolio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
